/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.ness.core.Datalake;
import io.intino.ness.core.Scale;
import io.intino.ness.core.Timetag;
import io.intino.ness.core.fs.FS;
import io.intino.ness.core.fs.FSSetTub;
import java.io.File;
import java.time.LocalDateTime;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FSSetTank
implements Datalake.SetStore.Tank {
    private final File root;

    public FSSetTank(File root) {
        this.root = root;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Datalake.SetStore.Tank.Tub first() {
        return this.tubs().findFirst().orElse(this.currentTub());
    }

    @Override
    public Datalake.SetStore.Tank.Tub last() {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(FSSetTub::new).findFirst().orElse(this.currentTub());
    }

    @Override
    public Datalake.SetStore.Tank.Tub on(Timetag tag) {
        return new FSSetTub(new File(this.root, tag.value()));
    }

    @Override
    public Stream<Datalake.SetStore.Tank.Tub> tubs() {
        return FS.foldersIn(this.root).map(FSSetTub::new);
    }

    @Override
    public Stream<Datalake.SetStore.Tank.Tub> tubs(int count) {
        return FS.foldersIn(this.root, FS.Sort.Reversed).map(f -> new FSSetTub((File)f)).limit(count);
    }

    @Override
    public Stream<Datalake.SetStore.Tank.Tub> tubs(Timetag from, Timetag to) {
        return StreamSupport.stream(from.iterateTo(to).spliterator(), false).map(this::on);
    }

    private FSSetTub currentTub() {
        return new FSSetTub(new File(this.root, new Timetag(LocalDateTime.now(), Scale.Month).toString()));
    }
}

