/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.core.Blob;
import io.intino.ness.core.Datalake;
import io.intino.ness.core.fs.FS;
import io.intino.ness.core.fs.FSEventStore;
import io.intino.ness.core.fs.FSSetStore;
import io.intino.ness.core.sessions.EventSessionManager;
import io.intino.ness.core.sessions.SetSessionManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.stream.Stream;

public class FSDatalake
implements Datalake {
    private static final String EventStoreFolder = "events";
    private static final String SetStoreFolder = "sets";
    private static final String StageFolder = "stage";
    private static final String TreatedFolder = "treated";
    public static final String BlobExtension = ".blob";
    private File root;

    public FSDatalake(File root) {
        this.root = root;
        this.mkdirs();
    }

    @Override
    public Datalake.Connection connection() {
        return new Datalake.Connection(){

            @Override
            public void connect(String ... args) {
            }

            @Override
            public void disconnect() {
            }
        };
    }

    @Override
    public Datalake.EventStore eventStore() {
        return new FSEventStore(this.eventStoreFolder());
    }

    @Override
    public Datalake.SetStore setStore() {
        return new FSSetStore(this.setStoreFolder());
    }

    @Override
    public void push(Stream<Blob> blobs) {
        blobs.forEach(this::process);
    }

    private void process(Blob blob) {
        if (blob.type() == Blob.Type.event) {
            EventSessionManager.push(this.stageFolder(), blob);
        }
        if (blob.type() == Blob.Type.set || blob.type() == Blob.Type.setMetadata) {
            SetSessionManager.push(blob, this.stageFolder());
        }
    }

    @Override
    public void seal() {
        EventSessionManager.seal(this.stageFolder(), this.eventStoreFolder());
        SetSessionManager.seal(this.stageFolder(), this.setStoreFolder());
        this.moveToTreated();
    }

    private void moveToTreated() {
        File treatedFolder = new File(this.treatedFolder(), this.sealDateFolderName());
        treatedFolder.mkdirs();
        FS.filesIn(this.stageFolder(), File::isFile).forEach(f -> this.move((File)f, treatedFolder));
    }

    private void move(File stageFile, File treatedFolder) {
        try {
            Files.move(stageFile.toPath(), new File(treatedFolder, stageFile.getName()).toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String sealDateFolderName() {
        return Instant.now().toString().substring(0, 19).replaceAll("[:T\\-]", "");
    }

    private void mkdirs() {
        this.eventStoreFolder().mkdirs();
        this.setStoreFolder().mkdirs();
        this.stageFolder().mkdirs();
        this.treatedFolder().mkdirs();
    }

    private File eventStoreFolder() {
        return new File(this.root, EventStoreFolder);
    }

    private File setStoreFolder() {
        return new File(this.root, SetStoreFolder);
    }

    private File stageFolder() {
        return new File(this.root, StageFolder);
    }

    private File treatedFolder() {
        return new File(this.root, TreatedFolder);
    }
}

