/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.senders;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.messaging.Messaging;
import io.intino.monet.messaging.Notification;
import io.intino.monet.messaging.NotificationTemplate;
import io.intino.monet.messaging.Recipient;
import io.intino.monet.messaging.Sender;
import io.intino.monet.messaging.pushnotifications.PushNotification;
import java.util.Map;

public class PushSender
implements Sender {
    private final Messaging messaging;

    public PushSender(Messaging messaging) {
        this.messaging = messaging;
    }

    @Override
    public boolean send(Notification notification) {
        try {
            if (notification.channel() != Notification.Channel.Push) {
                return false;
            }
            if (!this.messaging.pushNotifications().service().enabled()) {
                return false;
            }
            if (this.messaging.pushNotifications().blacklist().isDisabled(notification.type())) {
                return false;
            }
            return this.sendPushNotification(notification);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private boolean sendPushNotification(Notification notification) {
        Recipient recipient = notification.recipient();
        String recipientEmail = recipient.email();
        if (recipient.deviceToken() == null) {
            recipient = this.messaging.recipientsStore().get(recipient.email());
        }
        if (recipient == null || recipient.deviceToken() == null) {
            Logger.warn((String)("Recipient " + recipientEmail + " does not defines a device token. Cannot send push notification"));
            return false;
        }
        NotificationTemplate template = this.messaging.pushNotifications().getPushTemplate(notification.type(), notification.language());
        if (template == null) {
            return false;
        }
        for (String variable : template.properties()) {
            template.set(variable, notification.properties().getOrDefault(variable, ""));
        }
        PushNotification push = new PushNotification(notification.id()).recipient(recipient).title(template.subject()).body(template.body()).ts(notification.ts());
        push.properties().putAll(notification.properties());
        for (Map.Entry<String, Notification.Attachment> attachment : notification.attachments().entrySet()) {
            push.putExtraData(attachment.getKey(), attachment.getValue().value);
        }
        this.messaging.pushNotifications().service().send(push);
        return true;
    }
}

