/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.pushnotifications.backends.firebase;

import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.Notification;
import io.intino.monet.messaging.pushnotifications.PushNotification;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FirebaseMessageBuilder {
    public static Message build(PushNotification n) {
        return FirebaseMessageBuilder.buildMessage(n.recipient().deviceToken(), FirebaseMessageBuilder.map(n), n.extraData());
    }

    private static Message buildMessage(String deviceToken, Notification notification, List<PushNotification.ExtraData> extraData) {
        return Message.builder().putAllData(FirebaseMessageBuilder.dataFrom(extraData)).setToken(deviceToken).setNotification(notification).build();
    }

    private static Map<String, String> dataFrom(List<PushNotification.ExtraData> data) {
        if (data == null) {
            return new HashMap<String, String>();
        }
        return data.stream().collect(Collectors.toMap(PushNotification.ExtraData::key, PushNotification.ExtraData::value, (d1, d2) -> d1));
    }

    private static Notification map(PushNotification notification) {
        return Notification.builder().setBody(FirebaseMessageBuilder.safe(notification.body())).setTitle(FirebaseMessageBuilder.safe(notification.title())).build();
    }

    private static String safe(String value) {
        return value == null ? "" : value;
    }
}

