/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.pushnotifications;

import com.google.common.collect.Lists;
import io.intino.alexandria.Json;
import io.intino.monet.messaging.pushnotifications.PushNotification;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PushNotificationStore {
    private final File root;
    private final int maxNotificationsPerUser;
    private final Object mutex = new Object();

    public PushNotificationStore(File root) {
        this(root, 64);
    }

    public PushNotificationStore(File root, int maxNotificationsPerUser) {
        this.root = Objects.requireNonNull(root);
        root.mkdirs();
        this.maxNotificationsPerUser = maxNotificationsPerUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PushNotification> loadNotifications(String user) {
        Object object = this.mutex;
        synchronized (object) {
            List<PushNotification> list;
            block13: {
                File file = new File(this.root, user + ".json");
                if (!file.exists() || file.length() == 0L) {
                    return new ArrayList<PushNotification>();
                }
                Stream<String> lines = Files.lines(file.toPath());
                try {
                    list = lines.filter(line -> !line.isBlank()).map(this::deserialize).filter(Objects::nonNull).collect(Collectors.toList());
                    if (lines == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (lines != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return new ArrayList<PushNotification>();
                    }
                }
                lines.close();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveNotifications(String user, List<PushNotification> notifications) {
        Object object = this.mutex;
        synchronized (object) {
            File file = new File(this.root, user + ".json");
            try {
                List<String> json = this.serialize(notifications);
                if (json.isEmpty()) {
                    return true;
                }
                Files.write(file.toPath(), json, StandardOpenOption.CREATE);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(PushNotification notification) {
        Object object = this.mutex;
        synchronized (object) {
            List<PushNotification> notifications = this.loadNotifications(notification.recipient().email());
            notifications.add(notification);
            this.saveNotifications(notification.recipient().email(), notifications);
        }
    }

    private List<String> serialize(List<PushNotification> notifications) {
        return Lists.reverse(notifications).stream().limit(this.maxNotificationsPerUser).sorted(Comparator.comparing(PushNotification::ts)).map(this::serialize).collect(Collectors.toList());
    }

    private String serialize(PushNotification notification) {
        return Json.toString((Object)notification);
    }

    private PushNotification deserialize(String json) {
        return (PushNotification)Json.fromString((String)json, PushNotification.class);
    }

    public File root() {
        return this.root;
    }

    public int maxNotificationsPerUser() {
        return this.maxNotificationsPerUser;
    }
}

