/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.pushnotifications;

import io.intino.monet.messaging.pushnotifications.PushNotification;
import io.intino.monet.messaging.pushnotifications.PushNotificationServicePipeline;
import io.intino.monet.messaging.pushnotifications.PushNotificationStore;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class PushNotificationService {
    private final PushNotificationStore store;
    private final ExecutorService executor;
    private PushNotificationServicePipeline pipeline = new PushNotificationServicePipeline.Default();
    private volatile boolean enabled = true;

    public PushNotificationService(PushNotificationStore store) {
        this.store = Objects.requireNonNull(store);
        this.executor = Executors.newSingleThreadExecutor();
    }

    public final void send(PushNotification notification) {
        if (!this.enabled) {
            return;
        }
        this.executor.submit(() -> {
            this.sendNotification(notification);
            this.saveNotificationToUsersStore(notification);
        });
    }

    protected abstract void sendNotification(PushNotification var1);

    private void saveNotificationToUsersStore(PushNotification notification) {
        this.store.addNotification(notification);
    }

    public boolean shutdown() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.HOURS);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public PushNotificationService enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PushNotificationServicePipeline notificationPipeline() {
        return this.pipeline;
    }

    public PushNotificationService setNotificationPipeline(PushNotificationServicePipeline pipeline) {
        this.pipeline = pipeline == null ? new PushNotificationServicePipeline.Default() : pipeline;
        return this;
    }

    public PushNotificationStore store() {
        return this.store;
    }
}

