/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.pushnotifications;

import io.intino.alexandria.Json;
import io.intino.monet.messaging.Recipient;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PushNotification {
    private final String id;
    private Recipient recipient;
    private String title;
    private String body;
    private Instant ts = Instant.now();
    private boolean read;
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final List<ExtraData> extraData = new LinkedList<ExtraData>();

    public PushNotification(String id) {
        this.id = id;
    }

    public Recipient recipient() {
        return this.recipient;
    }

    public PushNotification recipient(Recipient recipient) {
        this.recipient = Objects.requireNonNull(recipient);
        return this;
    }

    public String id() {
        return this.id;
    }

    public String title() {
        return this.title;
    }

    public PushNotification title(String title) {
        this.title = title;
        return this;
    }

    public String body() {
        return this.body;
    }

    public PushNotification body(String body) {
        this.body = body;
        return this;
    }

    public Instant ts() {
        return this.ts;
    }

    public PushNotification ts(Instant ts) {
        this.ts = ts;
        return this;
    }

    public boolean read() {
        return this.read;
    }

    public PushNotification read(boolean read) {
        this.read = read;
        return this;
    }

    public List<ExtraData> extraData() {
        return this.extraData;
    }

    public PushNotification putExtraData(String key, String value) {
        this.extraData.add(new ExtraData(key, value));
        return this;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public PushNotification putProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String toString() {
        return Json.toString((Object)this);
    }

    public static class ExtraData {
        private final String key;
        private final String value;

        public ExtraData(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }
    }
}

