/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.emails.util;

import io.intino.monet.messaging.Recipient;
import io.intino.monet.messaging.emails.Email;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MimeMessageBuilder {
    private Session session;
    private Email email;
    private String senderAddress;
    private String senderName;

    public MimeMessage build() {
        try {
            MimeMessage message = new MimeMessage(this.session);
            this.setSenderInfo(message);
            this.setRecipientInfo(message, this.email);
            message.setSubject(this.email.subject());
            message.setContent(MimeMessageBuilder.createContent(this.email));
            return message;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Multipart createContent(Email email) throws IOException, MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)MimeMessageBuilder.createBody(email.body()));
        for (File attachment : email.body().attachments()) {
            multipart.addBodyPart((BodyPart)MimeMessageBuilder.createAttachment(attachment));
        }
        return multipart;
    }

    private static MimeBodyPart createBody(Email.Body body) throws MessagingException {
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)body.text(), body.contentType());
        return textPart;
    }

    private static MimeBodyPart createAttachment(File attachment) throws IOException, MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        attachmentPart.attachFile(attachment);
        return attachmentPart;
    }

    private void setRecipientInfo(MimeMessage message, Email email) throws MessagingException {
        message.setRecipients(Message.RecipientType.TO, this.internetAddresses(List.of(email.recipients().to())));
        if (!email.recipients().cc().isEmpty()) {
            message.setRecipients(Message.RecipientType.CC, this.internetAddresses(email.recipients().cc()));
        }
        if (!email.recipients().bcc().isEmpty()) {
            message.setRecipients(Message.RecipientType.BCC, this.internetAddresses(email.recipients().bcc()));
        }
    }

    private Address[] internetAddresses(List<Recipient> recipients) {
        return (Address[])recipients.stream().map(Recipient::email).map(this::toInternetAddress).toArray(Address[]::new);
    }

    private InternetAddress toInternetAddress(String email) {
        try {
            return new InternetAddress(email);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void setSenderInfo(MimeMessage message) throws Exception {
        message.setFrom((Address)new InternetAddress(this.senderAddress, this.senderName));
    }

    public MimeMessageBuilder session(Session session) {
        this.session = session;
        return this;
    }

    public MimeMessageBuilder email(Email email) {
        this.email = email;
        return this;
    }

    public MimeMessageBuilder senderAddress(String senderAddress) {
        this.senderAddress = senderAddress;
        return this;
    }

    public MimeMessageBuilder senderName(String senderName) {
        this.senderName = senderName;
        return this;
    }
}

