/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.emails.store;

import io.intino.monet.messaging.emails.store.EmailStore;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EmailsSent
implements EmailStore.Node {
    private transient EmailStore store;
    private final String recipient;
    private final List<EmailSent> emailsAlreadySent;

    EmailsSent(String recipient) {
        this.recipient = recipient;
        this.emailsAlreadySent = new ArrayList<EmailSent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String signature, LocalDateTime ts) {
        EmailsSent emailsSent = this;
        synchronized (emailsSent) {
            EmailSent emailSent = this.get(signature);
            if (emailSent != null) {
                LocalDateTime lastTimeItWasSent = emailSent.ts;
                emailSent.ts = Objects.requireNonNull(ts);
                return this.sameDay(lastTimeItWasSent, ts.toLocalDate());
            }
            emailSent = new EmailSent(signature, ts);
            this.emailsAlreadySent.add(emailSent);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EmailSent emailSent) {
        if (emailSent == null) {
            return;
        }
        EmailsSent emailsSent = this;
        synchronized (emailsSent) {
            this.emailsAlreadySent.remove(emailSent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIf(Predicate<EmailSent> predicate) {
        if (predicate == null) {
            return false;
        }
        EmailsSent emailsSent = this;
        synchronized (emailsSent) {
            return this.emailsAlreadySent.removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EmailsSent emailsSent = this;
        synchronized (emailsSent) {
            this.emailsAlreadySent.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmailSent get(String signature) {
        if (signature == null) {
            return null;
        }
        EmailsSent emailsSent = this;
        synchronized (emailsSent) {
            return this.emailsAlreadySent.stream().filter(e -> e.id.equals(signature)).findFirst().orElse(null);
        }
    }

    public long getTimeSinceSent(String signature, LocalDateTime reference, TimeUnit unit) {
        if (signature == null) {
            return Integer.MIN_VALUE;
        }
        EmailSent emailSent = this.get(signature);
        if (emailSent == null) {
            return Integer.MIN_VALUE;
        }
        return unit.toChronoUnit().between(emailSent.ts, reference);
    }

    public boolean wasSentToday(String signature) {
        if (signature == null) {
            return false;
        }
        EmailSent emailSent = this.get(signature);
        if (emailSent == null) {
            return false;
        }
        return this.sameDay(emailSent.ts, LocalDate.now());
    }

    private boolean sameDay(LocalDateTime ts1, LocalDate ts2) {
        return ts2.equals(ts1.toLocalDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EmailSent> getAll() {
        EmailsSent emailsSent = this;
        synchronized (emailsSent) {
            return this.emailsAlreadySent.stream().sorted(Comparator.comparing(EmailSent::ts)).collect(Collectors.toList());
        }
    }

    @Override
    public String id() {
        return this.recipient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        EmailsSent emailsSent = this;
        synchronized (emailsSent) {
            this.store.save(this);
        }
    }

    EmailsSent datamart(EmailStore store) {
        this.store = store;
        return this;
    }

    public String toString() {
        return "EmailsSent{recipient='" + this.recipient + "', emailsAlreadySent=" + this.emailsAlreadySent + "}";
    }

    public static class EmailSent {
        private final String id;
        private LocalDateTime ts;

        public EmailSent(String id, LocalDateTime ts) {
            this.id = Objects.requireNonNull(id);
            this.ts = Objects.requireNonNull(ts);
        }

        public String id() {
            return this.id;
        }

        public LocalDateTime ts() {
            return this.ts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmailSent emailSent = (EmailSent)o;
            return Objects.equals(this.id, emailSent.id) && Objects.equals(this.ts, emailSent.ts);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.ts);
        }

        public String toString() {
            return "EmailSent{id='" + this.id + "', ts=" + this.ts + "}";
        }
    }
}

