/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.emails.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.monet.messaging.emails.store.EmailBlacklist;
import io.intino.monet.messaging.emails.store.EmailStoreException;
import io.intino.monet.messaging.emails.store.EmailsSent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class EmailStore {
    private final File root;
    private final Gson gson;
    private final Map<String, EmailBlacklist> emailsBlacklistMap;
    private final Map<String, EmailsSent> emailsSentMap;
    private volatile boolean readOnly = false;

    public EmailStore(File root) {
        this.root = Objects.requireNonNull(root);
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException(root + " is not a directory");
        }
        root.mkdirs();
        this.gson = this.createGson();
        this.emailsBlacklistMap = new HashMap<String, EmailBlacklist>();
        this.emailsSentMap = new HashMap<String, EmailsSent>();
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public EmailStore readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmailBlacklist emailBlacklist(String recipient) {
        EmailStore emailStore = this;
        synchronized (emailStore) {
            EmailBlacklist node = this.emailsBlacklistMap.get(recipient);
            if (node == null) {
                node = this.load(recipient, EmailBlacklist.class);
            }
            node = node == null ? new EmailBlacklist(recipient) : node;
            this.emailsBlacklistMap.put(recipient, node);
            return node.datamart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EmailBlacklist> emailBlacklists(Predicate<EmailBlacklist> predicate) {
        EmailStore emailStore = this;
        synchronized (emailStore) {
            return this.emailsBlacklistMap.values().stream().filter(predicate).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmailsSent emailsSent(String recipient) {
        EmailStore emailStore = this;
        synchronized (emailStore) {
            EmailsSent node = this.emailsSentMap.get(recipient);
            if (node == null) {
                node = this.load(recipient, EmailsSent.class);
            }
            node = node == null ? new EmailsSent(recipient) : node;
            this.emailsSentMap.put(recipient, node);
            return node.datamart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EmailsSent> emailsSent(Predicate<EmailsSent> predicate) {
        EmailStore emailStore = this;
        synchronized (emailStore) {
            return this.emailsSentMap.values().stream().filter(predicate).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.readOnly) {
            return;
        }
        EmailStore emailStore = this;
        synchronized (emailStore) {
            this.emailsBlacklistMap.values().forEach(Node::save);
            this.emailsSentMap.values().forEach(Node::save);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(Node node) {
        if (this.readOnly) {
            return;
        }
        if (node == null) {
            return;
        }
        EmailStore emailStore = this;
        synchronized (emailStore) {
            this.serialize(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Node node) {
        if (this.readOnly) {
            return;
        }
        EmailStore emailStore = this;
        synchronized (emailStore) {
            try {
                File file = new File(this.root(), this.filename(node));
                file.getParentFile().mkdirs();
                Files.writeString(file.toPath(), (CharSequence)this.toJson(node), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                throw new EmailStoreException(e.getMessage(), e);
            }
        }
    }

    private <T extends Node> T load(String id, Class<T> type) {
        return this.loadFile(this.filename(type, id), type);
    }

    private <T extends Node> T loadFile(String filename, Class<T> type) {
        EmailStore emailStore = this;
        synchronized (emailStore) {
            File file = new File(this.root(), filename);
            String json = this.read(file);
            try {
                return (T)(json == null ? null : (Node)this.gson.fromJson(json, type));
            }
            catch (Exception e) {
                throw new EmailStoreException(e.getMessage(), e);
            }
        }
    }

    private String read(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            return Files.readString(file.toPath());
        }
        catch (IOException e) {
            throw new EmailStoreException(e.getMessage(), e);
        }
    }

    public File root() {
        return this.root;
    }

    private String filename(Node node) {
        return this.filename(node.getClass(), node.id());
    }

    private String filename(Class<?> clazz, String id) {
        return clazz.getSimpleName() + "/" + id + ".json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJson(Node node) {
        EmailStore emailStore = this;
        synchronized (emailStore) {
            return this.gson.toJson((Object)node);
        }
    }

    private Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(LocalDateTime.class, (ts, type, jsonSerializationContext) -> new JsonPrimitive(Timetag.of((LocalDateTime)ts, (Scale)Scale.Minute).value()));
        builder.registerTypeAdapter(LocalDateTime.class, (jsonElement, type, jsonSerializationContext) -> Timetag.of((String)jsonElement.getAsString()).datetime());
        return builder.create();
    }

    public static interface Node {
        public String id();

        public void save();
    }
}

