/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging.emails;

import io.intino.monet.messaging.emails.Email;
import io.intino.monet.messaging.emails.EmailServicePipeline;
import io.intino.monet.messaging.emails.EmailSessionFactory;
import io.intino.monet.messaging.emails.store.EmailBlacklist;
import io.intino.monet.messaging.emails.store.EmailStore;
import io.intino.monet.messaging.emails.util.MimeMessageBuilder;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class EmailService {
    public static final String SMTP_HOST = "mail.smtp.hostname";
    public static final String SMTP_USER = "mail.smtp.username";
    public static final String SMTP_PASSWORD = "mail.smtp.password";
    public static final int DEFAULT_MAX_CONNECTION_TRIES = 3;
    private final EmailStore store;
    private final Properties properties;
    private final ExecutorService executor;
    private EmailServicePipeline pipeline = new EmailServicePipeline.Default();
    private volatile boolean enabled = true;
    private final Session session;
    private final Transport transport;

    public EmailService(EmailStore store, Properties properties) {
        this.store = store;
        this.properties = Objects.requireNonNull(properties);
        this.executor = Executors.newSingleThreadExecutor();
        this.session = EmailSessionFactory.create(properties);
        this.transport = EmailSessionFactory.getTransport(this.session);
    }

    public void send(Email email) {
        this.send(Collections.singletonList(email));
    }

    public void send(List<Email> emails) {
        this.executor.submit(() -> this.sendEmails(emails));
    }

    private void sendEmails(List<Email> emails) {
        try {
            if (!this.enabled) {
                return;
            }
            this.connect();
            for (Email email : emails) {
                this.sendEmail(email);
            }
        }
        catch (Throwable e) {
            this.pipeline.onError(e);
        }
    }

    private synchronized void sendEmail(Email email) {
        boolean shouldSend;
        if (!this.enabled) {
            return;
        }
        if (!this.pipeline.onBeforeSendEmail(email)) {
            return;
        }
        boolean mustBeSentOncePerDay = this.mustBeSentOncePerDay(email);
        HashSet<Reason> reasonsForNotSending = new HashSet<Reason>(2);
        if (!this.couldSendNow(mustBeSentOncePerDay, email)) {
            reasonsForNotSending.add(Reason.AlreadySent);
        }
        if (!this.acceptedByRecipient(email)) {
            reasonsForNotSending.add(Reason.NotAcceptedByRecipient);
        }
        if (shouldSend = reasonsForNotSending.isEmpty()) {
            if (!this.sendMessage(this.buildMimeMessage(email))) {
                return;
            }
            if (mustBeSentOncePerDay) {
                this.registerEmailSent(email);
            }
        }
        this.pipeline.onAfterSendEmail(email, shouldSend, reasonsForNotSending);
    }

    private boolean sendMessage(MimeMessage message) {
        try {
            this.transport.sendMessage((Message)message, message.getAllRecipients());
            return true;
        }
        catch (MessagingException e) {
            this.pipeline.onError(e);
            return false;
        }
    }

    private MimeMessage buildMimeMessage(Email email) {
        return new MimeMessageBuilder().session(this.session).senderAddress(this.properties.getProperty("mail.from")).senderName(this.properties.getProperty("mail.from.name")).email(email).build();
    }

    private boolean acceptedByRecipient(Email email) {
        EmailBlacklist blacklist = this.store.emailBlacklist(email.recipients().to().email());
        return !blacklist.contains(email.signature());
    }

    private boolean couldSendNow(boolean mustBeSentOncePerDay, Email email) {
        if (mustBeSentOncePerDay) {
            return !this.wasAlreadySentToday(email);
        }
        return true;
    }

    private boolean wasAlreadySentToday(Email email) {
        return this.store.emailsSent(email.recipients().to().email()).wasSentToday(email.signature().get());
    }

    private void registerEmailSent(Email email) {
        this.store.emailsSent(email.recipients().to().email()).put(email.signature().get(), LocalDateTime.now());
    }

    private boolean mustBeSentOncePerDay(Email email) {
        return "true".equals(email.properties().get("oncePerDay"));
    }

    private synchronized void connect() throws Exception {
        Exception error = null;
        int maxConnectionTries = this.getMaxConnectionTries();
        for (int i = 0; i < maxConnectionTries; ++i) {
            error = this.tryConnectToSmtpServer();
            if (error == null) {
                return;
            }
            this.pipeline.onConnectionError(error);
            this.sleep(1000 * (i + 1));
        }
        if (error != null) {
            throw error;
        }
    }

    private int getMaxConnectionTries() {
        String tries = this.properties.getProperty("max.connection.tries");
        if (tries == null) {
            return 3;
        }
        try {
            int result = Integer.parseInt(tries);
            return result < 0 ? 3 : result;
        }
        catch (Exception e) {
            return 3;
        }
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Exception tryConnectToSmtpServer() {
        try {
            if (this.transport.isConnected()) {
                return null;
            }
            String host = this.properties.getProperty(SMTP_HOST);
            String user = this.properties.getProperty(SMTP_USER);
            String password = this.properties.getProperty(SMTP_PASSWORD);
            this.transport.connect(host, user, password);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    public boolean shutdown() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.HOURS);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public EmailService enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public EmailService setEmailServicePipeline(EmailServicePipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public EmailStore store() {
        return this.store;
    }

    public static enum Reason {
        NotAcceptedByRecipient,
        AlreadySent;

    }
}

