/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging;

import io.intino.monet.messaging.Messaging;
import io.intino.monet.messaging.Notification;
import io.intino.monet.messaging.senders.EmailSender;
import io.intino.monet.messaging.senders.PushSender;
import java.util.Objects;

public class NotificationHandler {
    private final Messaging messaging;

    public NotificationHandler(Messaging messaging) {
        this.messaging = Objects.requireNonNull(messaging);
    }

    public void handle(Notification notification) {
        if (notification.channel() == Notification.Channel.Email) {
            new EmailSender(this.messaging).send(notification);
        } else if (notification.channel() == Notification.Channel.Push) {
            new PushSender(this.messaging).send(notification);
        }
    }
}

