/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.messaging;

import io.intino.monet.messaging.MessageBlacklist;
import io.intino.monet.messaging.NotificationTemplate;
import io.intino.monet.messaging.RecipientsStore;
import io.intino.monet.messaging.emails.EmailService;
import io.intino.monet.messaging.emails.store.EmailStore;
import io.intino.monet.messaging.pushnotifications.PushNotificationService;
import io.intino.monet.messaging.pushnotifications.PushNotificationStore;
import java.io.File;
import java.util.Objects;

public class Messaging {
    private final File templatesRoot;
    private final RecipientsStore recipientsStore;
    private final Emails emails;
    private final PushNotifications pushNotifications;

    public Messaging(File templatesRoot, RecipientsStore recipientsStore, EmailService emailService, PushNotificationService notificationService) {
        this.templatesRoot = Objects.requireNonNull(templatesRoot);
        this.recipientsStore = recipientsStore;
        this.emails = new Emails(Objects.requireNonNull(emailService));
        this.pushNotifications = new PushNotifications(Objects.requireNonNull(notificationService));
    }

    public File templatesRoot() {
        return this.templatesRoot;
    }

    public RecipientsStore recipientsStore() {
        return this.recipientsStore;
    }

    public Emails emails() {
        return this.emails;
    }

    public PushNotifications pushNotifications() {
        return this.pushNotifications;
    }

    public static class Builder {
        private File templatesRoot;
        private RecipientsStore recipientsStore;
        private EmailService emailService;
        private PushNotificationService notificationService;

        public Messaging build() {
            return new Messaging(this.templatesRoot, this.recipientsStore, this.emailService, this.notificationService);
        }

        public Builder templatesRoot(File templatesRoot) {
            this.templatesRoot = templatesRoot;
            return this;
        }

        public Builder recipientsStore(RecipientsStore recipientsStore) {
            this.recipientsStore = recipientsStore;
            return this;
        }

        public Builder emailService(EmailService emailService) {
            this.emailService = emailService;
            return this;
        }

        public Builder notificationService(PushNotificationService notificationService) {
            this.notificationService = notificationService;
            return this;
        }
    }

    public class PushNotifications {
        private final PushNotificationService pushNotificationService;
        private final PushNotificationStore store;
        private final MessageBlacklist blacklist;

        PushNotifications(PushNotificationService pushNotificationService) {
            this.pushNotificationService = pushNotificationService;
            this.store = pushNotificationService.store();
            this.blacklist = new MessageBlacklist();
        }

        public PushNotificationService service() {
            return this.pushNotificationService;
        }

        public MessageBlacklist blacklist() {
            return this.blacklist;
        }

        public PushNotificationStore store() {
            return this.store;
        }

        public NotificationTemplate getPushTemplate(String type, String language) {
            return NotificationTemplate.load(new File(Messaging.this.templatesRoot(), "push"), type, language);
        }
    }

    public class Emails {
        private final EmailService emailService;
        private final EmailStore store;
        private final MessageBlacklist blacklist;

        private Emails(EmailService emailService) {
            this.emailService = emailService;
            this.store = emailService.store();
            this.blacklist = new MessageBlacklist();
        }

        public EmailService service() {
            return this.emailService;
        }

        public EmailStore store() {
            return this.store;
        }

        public MessageBlacklist blacklist() {
            return this.blacklist;
        }

        public NotificationTemplate getEmailTemplate(String type, String language) {
            return NotificationTemplate.load(new File(Messaging.this.templatesRoot(), "email"), type, language);
        }
    }
}

