package io.intino.monet.messaging.pushnotifications;

import io.intino.alexandria.Json;
import io.intino.monet.messaging.Recipient;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import static java.util.Objects.requireNonNull;

public class PushNotification {

    private final String id;
    private Recipient recipient;
    private String title;
    private String body;
    private Instant ts = Instant.now();
    private boolean read;
    private final Map<String, String> properties = new LinkedHashMap<>();
    private final List<ExtraData> extraData = new LinkedList<>();

    public PushNotification(String id) {
        this.id = id;
    }

    public Recipient recipient() {
        return recipient;
    }

    public PushNotification recipient(Recipient recipient) {
        this.recipient = requireNonNull(recipient);
        return this;
    }

    public String id() {
        return id;
    }

    public String title() {
        return title;
    }

    public PushNotification title(String title) {
        this.title = title;
        return this;
    }

    public String body() {
        return body;
    }

    public PushNotification body(String body) {
        this.body = body;
        return this;
    }

    public Instant ts() {
        return ts;
    }

    public PushNotification ts(Instant ts) {
        this.ts = ts;
        return this;
    }

    public boolean read() {
        return read;
    }

    public PushNotification read(boolean read) {
        this.read = read;
        return this;
    }

    public List<ExtraData> extraData() {
        return extraData;
    }

    public PushNotification putExtraData(String key, String value) {
        this.extraData.add(new ExtraData(key, value));
        return this;
    }

    public Map<String, String> properties() {
        return properties;
    }

    public PushNotification putProperty(String name, String value) {
        properties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        return Json.toString(this);
    }

    public static class ExtraData {

        private final String key;
        private final String value;

        public ExtraData(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return key;
        }

        public String value() {
            return value;
        }
    }
}
