package io.intino.monet.messaging.emails.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;

import java.time.Instant;

public class JsonPretty {

    public static String toJson(Object obj) {
        return gsonWriter().toJson(obj);
    }

    private static Gson gsonWriter() {
        return new GsonBuilder()
                .registerTypeAdapter(Instant.class,
                        (JsonSerializer<Instant>) (instant, type, jsonSerializationContext) -> new JsonPrimitive(instant.toEpochMilli()))
                .setPrettyPrinting()
                .create();
    }
}
