package io.intino.monet.messaging.emails;

import io.intino.alexandria.logger.Logger;

import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import java.util.Properties;

public class EmailSessionFactory {

    public static Session create(Properties properties) {
        return Session.getInstance(properties);
    }

    public static Transport getTransport(Session session) {
        try {
            return session.getTransport();
        } catch (NoSuchProviderException e) {
            Logger.error(e);
            throw new RuntimeException(e);
        }
    }
}
