package io.intino.monet.messaging.emails;

import java.util.Set;

public interface EmailServicePipeline {

    default boolean onBeforeSendEmail(Email email) { return true; }

    default void onAfterSendEmail(Email email, boolean sent, Set<EmailService.Reason> reasonsForNotSending) {}

    default void onError(Throwable e) {}

    default void onConnectionError(Exception e) {}

    class Default implements EmailServicePipeline {

    }
}
