package io.intino.monet.messaging.pushnotifications;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public interface PushNotificationServicePipeline {

    default boolean onBeforeSend(PushNotification notification) {return true;}

    default void onAfterSend(PushNotification notification, SendResult sendResult) {}

    default void onError(Throwable e) {}

    class Default implements PushNotificationServicePipeline { }

    class SendResult {

        public final List<SendResponse> responses = new LinkedList<>();

        public int successCount() {
            return (int) responses.stream().filter(r -> r.error == null).count();
        }

        public int failureCount() {
            return responses.size() - successCount();
        }

        @Override
        public String toString() {
            return "SendResult{" +
                    "responses=" + responses +
                    ", successCount=" + successCount() +
                    ", failureCount=" + failureCount() +
                    '}';
        }
    }

    class SendResponse {

        public final Map<String, String> info = new HashMap<>();
        public final Exception error;

        public SendResponse(Exception error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "SendResponse{" +
                    "info=" + info +
                    ", error=" + error +
                    '}';
        }
    }
}
