package io.intino.monet.messaging.logging;

import io.intino.alexandria.logger.Logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class FileLogHandler implements LogHandler {

	private PrintStream printStream;

	public FileLogHandler(File file) {
		file.getParentFile().mkdirs();
		try {
			printStream = new PrintStream(new FileOutputStream(file, true));
		} catch (FileNotFoundException e) {
			MessagingLog.error(e);
		}
	}

	@Override
	public void publish(Logger.Level level, String message) {
		if (printStream != null) printStream.print(message);
	}

	@Override
	public void close() {
		if (printStream == null) return;
		printStream.close();
		printStream = null;
	}
}
