package io.intino.monet.messaging;

import java.util.Objects;

public class Recipient {

    private final String email;
    private String deviceToken;

    public Recipient(String email) {
        this.email = email;
    }

    public String email() {
        return email;
    }

    public String deviceToken() {
        return deviceToken;
    }

    public Recipient deviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Recipient recipient = (Recipient) o;
        return Objects.equals(email, recipient.email);
    }

    @Override
    public int hashCode() {
        return Objects.hash(email);
    }

    @Override
    public String toString() {
        return "Recipient{" +
                "email='" + email + '\'' +
                ", deviceToken='" + deviceToken + '\'' +
                '}';
    }
}
