/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition;

import io.intino.monet.engine.edition.FormStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class LocalFormStore
implements FormStore {
    private final File folder;
    private final Map<String, Object> data;

    public LocalFormStore(File folder) {
        this.folder = folder;
        this.folder.mkdirs();
        this.data = new HashMap<String, Object>();
    }

    public File folder() {
        return this.folder;
    }

    public void load() throws IOException {
        this.data.clear();
        this.data.putAll(this.read(this.target().toPath()));
    }

    public void save() throws IOException {
        this.target().delete();
        this.write(this.target().toPath());
    }

    private Map<String, Object> read(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        return lines.stream().map(this::parse).filter(Objects::nonNull).collect(Collectors.toMap(v -> v.key, v -> v.value));
    }

    private void write(Path path) throws IOException {
        for (String key : this.data.keySet()) {
            Files.write(path, new Variable(key, this.data.get(key)).serialize(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    private Variable parse(String line) {
        return !line.isEmpty() ? new Variable(line.split("\t")) : null;
    }

    @Override
    public List<String> keys() {
        return new ArrayList<String>(this.data.keySet());
    }

    @Override
    public Object get(String name) {
        Object value = this.data.get(name);
        return value != null ? this.get(value, this.file(name)) : null;
    }

    private Object get(Object value, File file) {
        Object[] objectArray;
        if (file != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = value;
            objectArray = objectArray2;
            objectArray2[1] = file;
        } else {
            objectArray = value;
        }
        return objectArray;
    }

    private File file(String name) {
        File file = new File(this.folder, name);
        return file.exists() ? file : null;
    }

    @Override
    public void put(String name, Object value) {
        if (value != null) {
            this.add(name, value);
        } else {
            this.remove(name);
        }
    }

    private void add(String name, Object value) {
        if (value instanceof File) {
            this.move(name, (File)value);
        } else if (value instanceof InputStream) {
            this.save(name, (InputStream)value);
        } else if (value instanceof Object[]) {
            Arrays.stream((Object[])value).forEach(v -> this.add(name, v));
        } else {
            this.data.put(name, value);
        }
    }

    private void remove(String name) {
        this.data.remove(name);
        new File(this.folder, name).delete();
    }

    private void move(String name, File file) {
        File dest = new File(this.folder, name);
        dest.getParentFile().mkdirs();
        file.renameTo(dest);
    }

    private void save(String name, InputStream is) {
        try {
            File destination = new File(this.folder, name);
            destination.getParentFile().mkdirs();
            Files.write(destination.toPath(), is.readAllBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    private File target() {
        return new File(this.folder, "data.tsv");
    }

    private static class Variable {
        public String key;
        public Object value;

        public Variable(String[] split) {
            this.key = split[0];
            this.value = this.parse(split[1], split.length >= 3 ? split[2] : "");
        }

        private Object parse(String type, String value) {
            if (type.equalsIgnoreCase("Double")) {
                return Double.parseDouble(value);
            }
            if (type.equalsIgnoreCase("LocalDate")) {
                return LocalDate.parse(value);
            }
            return value;
        }

        public Variable(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public byte[] serialize() {
            return (this.key + "\t" + this.typeOf(this.value) + "\t" + this.value + "\n").getBytes();
        }

        private String typeOf(Object value) {
            return value.getClass().getSimpleName();
        }
    }
}

