/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition.editors;

import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;
import java.util.Map;

public class NumberEdition
extends Edition {
    private final double min;
    private final double max;
    private final double defaultValue;

    public NumberEdition(String name, FormStore store, Map<String, String> options, Language language) {
        super(name, store, options, language);
        this.min = Double.parseDouble(options.getOrDefault("value-min", "0"));
        this.max = Double.parseDouble(options.getOrDefault("value-max", "99999999"));
        this.defaultValue = Double.parseDouble(options.getOrDefault("value-default", String.valueOf(this.min)));
    }

    public double get() {
        return (Double)this.value();
    }

    @Override
    public Object value() {
        Object value = super.value();
        if (value instanceof String && !this.isEmpty(value)) {
            return Double.valueOf((String)value);
        }
        return value;
    }

    public void set(double value) {
        this.store.put(this.name, value);
    }

    public double defaultValue() {
        return this.defaultValue;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }
}

