/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.engine.edition.FormStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class LocalFormStore
implements FormStore {
    private final File folder;
    private final Map<String, Object> data;
    private final List<Consumer<String>> onModifiedListeners = new ArrayList<Consumer<String>>();

    public LocalFormStore(File folder) {
        this.folder = folder;
        this.folder.mkdirs();
        this.data = new HashMap<String, Object>();
    }

    public File folder() {
        return this.folder;
    }

    public void load() throws IOException {
        this.data.clear();
        this.data.putAll(this.read(this.target().toPath()));
    }

    public void save() throws IOException {
        this.target().delete();
        this.write(this.target().toPath());
    }

    private Map<String, Object> read(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path);
        return lines.stream().map(this::parse).filter(Objects::nonNull).collect(Collectors.toMap(v -> v.key, v -> v.value, (v, m) -> m));
    }

    private void write(Path path) throws IOException {
        for (String key : this.data.keySet()) {
            Files.write(path, new Variable(key, this.data.get(key)).serialize(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    private Variable parse(String line) {
        return !line.isEmpty() ? new Variable(line.split("\t")) : null;
    }

    @Override
    public List<String> keys() {
        return new ArrayList<String>(this.data.keySet());
    }

    @Override
    public Object get(String name) {
        Object value = this.data.get(name);
        return value != null ? this.get(value, this.file(name)) : null;
    }

    private Object get(Object value, File file) {
        Object[] objectArray;
        if (file != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = value;
            objectArray = objectArray2;
            objectArray2[1] = file;
        } else {
            objectArray = value;
        }
        return objectArray;
    }

    private File file(String name) {
        File[] files = this.folder.listFiles(f -> this.withoutExtension(f.getName()).equals(name));
        return files == null || files.length == 0 ? null : files[0];
    }

    private String withoutExtension(String name) {
        int extensionBegin = name.lastIndexOf(46);
        return extensionBegin < 0 ? name : name.substring(0, extensionBegin);
    }

    @Override
    public void put(String name, Object value) {
        if (this.update(name, value)) {
            this.onModifiedListeners.forEach(listener -> listener.accept(name));
        }
    }

    private boolean update(String name, Object value) {
        if (value != null) {
            return this.add(name, value);
        }
        return this.remove(name);
    }

    private boolean add(String name, Object value) {
        if (value instanceof File) {
            return this.move(name, (File)value);
        }
        if (value instanceof InputStream) {
            return this.save(name, (InputStream)value);
        }
        if (value instanceof Object[]) {
            return Arrays.stream((Object[])value).map(v -> this.add(name, v)).reduce((a, b) -> a | b).orElse(false);
        }
        Object oldValue = this.data.put(name, value);
        return !Objects.equals(value, oldValue);
    }

    private boolean remove(String name) {
        return this.data.remove(name) != null && this.findAndDeleteFile(name);
    }

    private boolean findAndDeleteFile(String name) {
        File[] files = this.folder.listFiles(f -> f.isFile() && f.getName().startsWith(name + "."));
        if (files == null || files.length == 0) {
            return false;
        }
        return files[0].delete();
    }

    private boolean move(String name, File file) {
        File dest = new File(this.folder, name + this.getExtension(file));
        dest.getParentFile().mkdirs();
        file.renameTo(dest);
        return true;
    }

    private String getExtension(File file) {
        String name = file.getName();
        int extensionBegin = name.lastIndexOf(46);
        return extensionBegin < 0 ? "" : name.substring(extensionBegin);
    }

    private boolean save(String name, InputStream is) {
        try {
            File destination = new File(this.folder, name);
            destination.getParentFile().mkdirs();
            Files.write(destination.toPath(), is.readAllBytes(), StandardOpenOption.CREATE);
            return true;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void onModified(Consumer<String> listener) {
        this.onModifiedListeners.add(Objects.requireNonNull(listener));
    }

    private File target() {
        return new File(this.folder, "data.tsv");
    }

    private static class Variable {
        public String key;
        public Object value;

        public Variable(String[] split) {
            this.key = split[0];
            this.value = this.parse(split.length > 1 ? split[1] : "", split.length > 2 ? split[2] : "");
        }

        private Object parse(String type, String value) {
            if (type.equalsIgnoreCase("Double")) {
                return Double.parseDouble(value);
            }
            if (type.equalsIgnoreCase("LocalDate")) {
                return LocalDate.parse(value);
            }
            return value;
        }

        public Variable(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public byte[] serialize() {
            return (this.key + "\t" + this.typeOf(this.value) + "\t" + this.value + "\n").getBytes();
        }

        private String typeOf(Object value) {
            return value.getClass().getSimpleName();
        }
    }
}

