/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine;

import io.intino.alexandria.Json;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Order {
    private final String id;
    private final String code;
    private String input;
    private String properties;
    private Instant createDate;
    private Instant scheduleDate;
    private Instant dueDate;
    private static final String Recipients = "recipients";

    public Order(String id, String code) {
        this.id = id;
        this.code = code;
    }

    public String id() {
        return this.id;
    }

    public String code() {
        return this.code;
    }

    public String input() {
        return this.input;
    }

    public Order input(String input) {
        this.input = input;
        return this;
    }

    public Map<String, String> inputMap() {
        String input = this.input();
        if (input == null || input.isEmpty()) {
            return new HashMap<String, String>();
        }
        Map map = (Map)Json.fromString((String)input, Map.class);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
    }

    private List<String> recipients() {
        String recipients = this.property(Recipients);
        return recipients != null ? List.of(recipients.split("\\|")) : Collections.emptyList();
    }

    public String properties() {
        return this.properties;
    }

    public Order properties(String properties) {
        this.properties = properties;
        return this;
    }

    public String property(String name) {
        Map<String, String> properties = this.propertiesMap();
        return properties.getOrDefault(name, null);
    }

    public void add(String property, String value) {
        Map<String, String> properties = this.propertiesMap();
        properties.put(property, value);
        this.properties = Json.toString(properties);
    }

    public Map<String, String> propertiesMap() {
        String properties = this.properties();
        if (properties == null || properties.isEmpty()) {
            return new HashMap<String, String>();
        }
        Map map = (Map)Json.fromString((String)properties, Map.class);
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Order createDate(Instant createDate) {
        this.createDate = createDate;
        return this;
    }

    public Instant scheduleDate() {
        return this.scheduleDate;
    }

    public Order scheduleDate(Instant scheduleDate) {
        this.scheduleDate = scheduleDate;
        return this;
    }

    public Instant dueDate() {
        return this.dueDate;
    }

    public Order dueDate(Instant dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public boolean isDisabled() {
        return this.inputMap().containsKey("disabled");
    }

    public boolean isHighlighted() {
        return this.inputMap().containsKey("highlighted");
    }

    public boolean isStoreDefined() {
        return this.inputMap().containsKey("store");
    }

    public String store() {
        return this.inputMap().getOrDefault("store", this.clean(this.id));
    }

    private String clean(String id) {
        return id.replace(":", "-").replace("_", "-");
    }
}

