package io.intino.monet.engine.edition.editors.util;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public class DynamicSourceHelper {

	public static Stream<String> getDynamicRoute(String optionsSource) {
		return Arrays.stream(optionsSource.substring(1).split("::"));
	}

	public static Set<String> getVariables(String optionsSource) {
		Set<String> variables = new LinkedHashSet<>();
		int offset = 0;
		while(offset < optionsSource.length()) {
			int varIndex = optionsSource.indexOf("::", offset);
			if(varIndex < 0) break;
			offset = optionsSource.indexOf("::", varIndex + 2);
			variables.add(optionsSource.substring(varIndex + 2, offset));
			offset += 2;
		}
		return variables;
	}
}
