package io.intino.monet.engine;

import io.intino.monet.engine.OrderTypes.Checklist;

import java.util.HashMap;
import java.util.Map;

public class CheckListProvider {

	public Checklist findCheckList(String orderCode) {
		OrderTypes.Record orderType = OrderTypes.of(orderCode);
		return orderType != null ? orderType.checklist() : new Checklist();
	}

	public Map<Checklist.Field, Map<String, String>> findCheckListTriples(String orderCode) {
		OrderTypes.Record orderType = OrderTypes.of(orderCode);
		return orderType != null ? orderType.triples() : new HashMap<>();
	}

}
