/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OrderTypes {
    private static final Supplier<Map<String, Record>> MapFactory = HashMap::new;
    public static final String TEMPLATE_EXTENSION = ".docx";
    private static volatile Map<String, Record> records = MapFactory.get();
    private static final Map<String, BiConsumer<Record, String>> setters = new HashMap<String, BiConsumer<Record, String>>(){
        {
            this.put("label.en", (r, v) -> {
                r.labelEn = v;
            });
            this.put("label.es", (r, v) -> {
                r.labelEs = v;
            });
            this.put("label.pt", (r, v) -> {
                r.labelPt = v;
            });
            this.put("hint.en", (r, v) -> {
                r.hintEn = v;
            });
            this.put("hint.es", (r, v) -> {
                r.hintEs = v;
            });
            this.put("hint.pt", (r, v) -> {
                r.hintPt = v;
            });
            this.put("code", (r, v) -> {
                r.code = v;
            });
            this.put("effort", (r, v) -> {
                r.effort = Integer.parseInt(v);
            });
            this.put("input", (r, v) -> {
                r.input = v;
            });
            this.put("calculations", (r, v) -> {
                r.calculations = v;
            });
            this.put("annexes", (r, v) -> {
                r.annexes = v;
            });
            this.put("target", (r, v) -> {
                r.target = v;
            });
            this.put("channel", (r, v) -> {
                r.channel = Channel.valueOf(v);
            });
            this.put("parent", (r, v) -> {
                r.parent = v;
            });
            this.put("assertion", (r, v) -> {
                String[] split = v.split(":");
                r.assertionCode = split[0];
                r.assertionAttr = split.length == 1 ? Collections.emptyMap() : (Map)Arrays.stream(split[1].split(",")).map(s -> s.split(" as ")).collect(Collectors.toMap(s -> s[0].trim(), s -> ((String[])s).length == 1 ? s[0].trim() : s[1].trim(), (v1, v2) -> v1, LinkedHashMap::new));
            });
            this.put("report.filename", (r, v) -> {
                r.reportFilename = v;
            });
        }
    };

    public static void init(File file) {
        try {
            Map<String, Record> newRecords = MapFactory.get();
            Files.readAllLines(file.toPath()).stream().filter(l -> !l.trim().isEmpty()).map(l -> l.split("\t", -1)).forEach(l -> setters.getOrDefault(l[1], OrderTypes.nullSetter()).accept(OrderTypes.record(newRecords, l[0]), l[2]));
            newRecords.values().stream().sorted(OrderTypes.recordsWithNoParentsFirst()).forEach(r -> OrderTypes.load(file, r, newRecords));
            records = newRecords;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static Comparator<Record> recordsWithNoParentsFirst() {
        return (r1, r2) -> {
            if (r1.parent == null && r2.parent == null) {
                return 0;
            }
            return r1.parent == null ? -1 : 1;
        };
    }

    private static void load(File file, Record record, Map<String, Record> records) {
        if (record.parent != null) {
            OrderTypes.loadParentInfo(file, record, records);
            return;
        }
        OrderTypes.loadChecklistAndTriples(file, record, record.code);
    }

    private static void loadChecklistAndTriples(File file, Record record, String name) {
        File checklistFile = OrderTypes.checklistFile(file.getParentFile(), name);
        Map<String, List<String[]>> triples = Checklist.triples(checklistFile);
        record.checklist = Checklist.load(checklistFile);
        OrderTypes.setTriples(record, triples);
    }

    private static void loadParentInfo(File file, Record record, Map<String, Record> records) {
        if (record.parent == null) {
            return;
        }
        if (record.parent.equals(record.code)) {
            throw new IllegalStateException("Order-Type parent cannot be itself (" + record.code + ")");
        }
        Record parent = records.get(record.parent);
        if (parent == null) {
            return;
        }
        if (parent.parent != null && parent.parent.equals(record.code)) {
            throw new IllegalStateException("Cyclic inheritance is not allowed (" + record.code + "-" + parent.code + ")");
        }
        OrderTypes.inheritValuesFromParent(record, parent);
        OrderTypes.loadChecklistFromParent(file, record, records);
    }

    private static void loadChecklistFromParent(File file, Record record, Map<String, Record> records) {
        Checklist parentChecklist = OrderTypes.getChecklist(file.getParentFile(), record.parent);
        Checklist childChecklist = OrderTypes.getChecklist(file.getParentFile(), record.code);
        if (childChecklist == null) {
            OrderTypes.loadChecklistAndTriples(file, record, record.parent);
            return;
        }
        record.checklist = parentChecklist == null ? childChecklist : Checklist.merge(parentChecklist, childChecklist);
        HashMap<String, List<String[]>> triples = parentChecklist != null ? Checklist.triples(OrderTypes.checklistFile(file.getParentFile(), record.parent)) : new HashMap<String, List<String[]>>();
        triples.putAll(Checklist.triples(OrderTypes.checklistFile(file.getParentFile(), record.code)));
        OrderTypes.setTriples(record, triples);
    }

    private static void setTriples(Record record, Map<String, List<String[]>> triples) {
        record.triples = record.checklist.fields.stream().sorted(Comparator.comparing(e -> e.code)).collect(Collectors.toMap(e -> e, e -> Checklist.asMap(Checklist.triples(triples.getOrDefault(e.code, Collections.emptyList()))), (a, v) -> a, LinkedHashMap::new));
    }

    private static Checklist getChecklist(File root, String name) {
        File file = OrderTypes.checklistFile(root, name);
        return file.exists() ? Checklist.load(file) : null;
    }

    private static File checklistFile(File root, String name) {
        return new File(root, "order-types/" + name + ".triples");
    }

    private static void inheritValuesFromParent(Record record, Record parent) {
        if (record.labelEn == null) {
            record.labelEn = parent.labelEn;
        }
        if (record.labelEs == null) {
            record.labelEs = parent.labelEs;
        }
        if (record.labelPt == null) {
            record.labelPt = parent.labelPt;
        }
        if (record.hintEn == null) {
            record.hintEn = parent.hintEn;
        }
        if (record.hintEs == null) {
            record.hintEs = parent.hintEs;
        }
        if (record.hintPt == null) {
            record.hintPt = parent.hintPt;
        }
        if (record.target == null) {
            record.target = parent.target;
        }
        if (record.effort == 0) {
            record.effort = parent.effort;
        }
        if (record.input == null) {
            record.input = parent.input;
        }
        if (record.calculations == null) {
            record.calculations = parent.calculations;
        }
        if (record.annexes == null) {
            record.annexes = parent.annexes;
            record.codeForAnnexes = parent.codeForAnnexes();
        }
        if (record.channel == null) {
            record.channel = parent.channel;
        }
        if (record.assertionCode == null) {
            record.assertionCode = parent.assertionCode;
        }
        if (record.assertionAttr == null) {
            record.assertionAttr = parent.assertionAttr;
        }
        if (record.reportFilename == null) {
            record.reportFilename = parent.reportFilename;
        }
    }

    private static BiConsumer<Record, String> nullSetter() {
        return (record, s) -> {};
    }

    public static Collection<Record> all() {
        return records.values();
    }

    public static Record of(String code) {
        return records.get(code);
    }

    private static Record record(Map<String, Record> records, String id) {
        if (!records.containsKey(id)) {
            Record record = new Record();
            record.code = id;
            records.put(id, record);
        }
        return records.get(id);
    }

    public static class Checklist
    implements Iterable<Field> {
        private final List<Field> fields = new ArrayList<Field>();

        private static Checklist load(File file) {
            return Checklist.load(Checklist.triples(file));
        }

        private static Checklist load(Map<String, List<String[]>> triples) {
            Checklist checklist = new Checklist();
            for (String key : triples.keySet()) {
                checklist.add(key, Checklist.triples(triples.get(key)));
            }
            Checklist.init(checklist);
            return checklist;
        }

        private static Checklist merge(Checklist parent, Checklist child) {
            Checklist checklist = new Checklist();
            checklist.fields.addAll(parent.fields);
            for (Field f : child) {
                Checklist.removeIfAlreadyExists(checklist, f);
                Checklist.append(checklist, f);
            }
            Checklist.init(checklist);
            return checklist;
        }

        private static void removeIfAlreadyExists(Checklist checklist, Field f) {
            checklist.fields.removeIf(field -> field.name.equals(f.name));
        }

        private static void append(Checklist checklist, Field f) {
            checklist.fields.add(f);
        }

        private static void init(Checklist checklist) {
            Checklist.sort(checklist.fields);
            checklist.setMarkers();
        }

        private static void sort(List<Field> fields) {
            fields.sort(Comparator.comparing(f -> f.code));
        }

        private static List<Entry> triples(List<String[]> splits) {
            return splits.stream().map(Entry::new).collect(Collectors.toList());
        }

        private static Map<String, String> asMap(List<Entry> entries) {
            HashMap<String, String> map = new HashMap<String, String>(entries.size());
            for (Entry entry : entries) {
                map.put(entry.key, entry.value);
            }
            return map;
        }

        private static Map<String, List<String[]>> triples(File file) {
            try {
                return Files.readAllLines(file.toPath()).stream().filter(s -> !s.isEmpty()).map(s -> s.split("\t")).collect(Collectors.groupingBy(s -> s[0]));
            }
            catch (IOException ignored) {
                return Collections.emptyMap();
            }
        }

        private void setMarkers() {
            Field marker = null;
            for (Field field : this.fields) {
                if (field.type == Type.Marker || field.type == Type.Section) {
                    marker = field;
                    continue;
                }
                if (marker == null) continue;
                field.marker(marker);
            }
        }

        public Field field(String key) {
            return this.fields.stream().filter(f -> f.code.equalsIgnoreCase(key) || f.name.equalsIgnoreCase(key)).findFirst().orElse(null);
        }

        public List<Field> fields() {
            return this.fields;
        }

        private void add(String code, List<Entry> entries) {
            this.add(new Field(code, Checklist.asMap(entries)));
        }

        private void add(Field field) {
            this.fields.add(field);
        }

        @Override
        public Iterator<Field> iterator() {
            return this.fields.iterator();
        }

        public static class AnnexInstance
        extends Annex {
            private static final String FIELD_ATTRIB_MARK = "$";
            public final String instanceName;
            private final Map<String, String> attributes;

            private AnnexInstance(String name, Field check) {
                super(name);
                this.instanceName = name + FIELD_ATTRIB_MARK + check.code;
                this.attributes = check.entries().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("annex.") ? ((String)e.getKey()).replace("annex.", "") : FIELD_ATTRIB_MARK + (String)e.getKey(), Map.Entry::getValue));
                this.attributes.put("$code", check.code);
                this.attributes.put("$name", check.name.replace("+" + name, ""));
                this.attributes.put("$index", check.code.substring(check.code.indexOf(46) + 1));
            }

            public Map<String, String> attributes(String language) {
                return this.attributes.entrySet().stream().filter(e -> this.matchesLanguageOrIsGlobal((Map.Entry<String, String>)e, language)).collect(Collectors.toMap(e -> ((String)e.getKey()).replace("." + language, ""), Map.Entry::getValue));
            }

            private boolean matchesLanguageOrIsGlobal(Map.Entry<String, String> entry, String language) {
                int langStart = entry.getKey().lastIndexOf(46);
                if (langStart < 0) {
                    return true;
                }
                String attribLang = entry.getKey().substring(langStart + 1);
                if (Locale.forLanguageTag(attribLang) == null) {
                    return true;
                }
                return language.equals(attribLang);
            }
        }

        public static class AnnexShared
        extends Annex {
            private AnnexShared(String name) {
                super(name);
            }
        }

        public static abstract class Annex {
            public final String name;

            Annex(String name) {
                this.name = name;
            }

            public Type type() {
                return this instanceof AnnexInstance ? Type.instance : Type.shared;
            }

            public static enum Type {
                shared,
                instance;

            }
        }

        public static class Entry {
            public final String key;
            public final String value;

            public Entry(String[] split) {
                this(split[1], split[2]);
            }

            public Entry(String key, String value) {
                this.key = key;
                this.value = value;
            }
        }

        public static class Field {
            public final String name;
            public final Type type;
            private final String code;
            private final boolean optional;
            private final String conditional;
            private final List<String> filter;
            private final Map<String, String> entries;
            private Field marker;

            public Field(String code, Map<String, String> entries) {
                this.code = code;
                this.name = entries.get("name");
                this.type = Type.valueOf(entries.getOrDefault("type", "String"));
                this.entries = entries;
                this.optional = Boolean.parseBoolean(entries.getOrDefault("optional", "false"));
                this.filter = Field.toList(entries.getOrDefault("filter", ""));
                this.conditional = entries.get("conditional");
            }

            public Map<String, String> entries() {
                return Collections.unmodifiableMap(this.entries);
            }

            public Annex annex() {
                int annexStart = this.name.indexOf(43);
                return annexStart < 0 ? null : this.getAnnex();
            }

            private Annex getAnnex() {
                return this.hasAnnexInstance() ? new AnnexInstance(this.annexName(), this) : new AnnexShared(this.annexName());
            }

            private boolean hasAnnexInstance() {
                return this.entries.getOrDefault("annex.type", Annex.Type.shared.name()).equals(Annex.Type.instance.name());
            }

            private String annexName() {
                int annexStart = this.name.indexOf(43);
                return annexStart < 0 ? null : this.name.substring(annexStart + 1);
            }

            public String title(String language) {
                return this.get("title.", language);
            }

            public String description(String language) {
                return this.get("description.", language);
            }

            public List<String> values(String language) {
                return Stream.of(this.get("values.", language).split(";")).map(String::trim).collect(Collectors.toList());
            }

            public Double valueMin() {
                return this.entries.containsKey("value-min") ? Double.valueOf(Double.parseDouble(this.entries.get("value-min"))) : null;
            }

            public Double valueMax() {
                return this.entries.containsKey("value-max") ? Double.valueOf(Double.parseDouble(this.entries.get("value-max"))) : null;
            }

            public Double valueDefault() {
                return this.entries.containsKey("value-default") ? Double.parseDouble(this.entries.get("value-default")) : 0.0;
            }

            public String unit() {
                return this.entries.get("unit");
            }

            public boolean isOptional() {
                return this.optional;
            }

            public boolean isConditional() {
                return this.conditional != null;
            }

            public String conditional() {
                return this.conditional;
            }

            public List<String> filter() {
                return this.filter;
            }

            public Field marker() {
                return this.marker;
            }

            public String get(String attribute, String language) {
                return this.entries.getOrDefault(attribute + language, "");
            }

            public String toString() {
                return "Field{type=" + this.type + ", name='" + this.name + "'}";
            }

            private void marker(Field marker) {
                this.marker = marker;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Field field = (Field)o;
                return Objects.equals(this.name, field.name) && this.type == field.type;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.name, this.type});
            }

            static List<String> toList(String value) {
                if (value == null) {
                    return Collections.emptyList();
                }
                return Stream.of(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            }
        }

        public static enum Type {
            String,
            Number,
            Date,
            Option,
            MultiOption,
            Image,
            Entity,
            Package,
            Note,
            Marker,
            Section,
            Validation,
            Signature;

        }
    }

    public static class Record {
        public static final String ANNEX_SEPARATOR = "$";
        private String code;
        private String labelEn;
        private String labelEs;
        private String labelPt;
        private String hintEn;
        private String hintEs;
        private String hintPt;
        private String target;
        private int effort;
        private String input;
        private String calculations;
        private String annexes;
        private Channel channel;
        private String assertionCode;
        private String parent;
        private Checklist checklist = new Checklist();
        private Map<Checklist.Field, Map<String, String>> triples = new HashMap<Checklist.Field, Map<String, String>>();
        private Map<String, String> assertionAttr;
        private String reportFilename;
        private String codeForAnnexes;

        public String code() {
            return this.code;
        }

        public String label(String lang) {
            return lang.equals("en") ? this.labelEn : (lang.equals("es") ? this.labelEs : this.labelPt);
        }

        public String hint(String lang) {
            return lang.equals("en") ? this.hintEn : (lang.equals("es") ? this.hintEs : this.hintPt);
        }

        public String category() {
            return this.code.startsWith("P") ? "Preventive" : (this.code.startsWith("A") ? "Administrative" : "Corrective");
        }

        public int effort() {
            return this.effort;
        }

        public boolean isManual() {
            return this.input == null || this.input.isEmpty();
        }

        public List<String> input() {
            if (this.input == null) {
                return Collections.emptyList();
            }
            return Stream.of(this.input.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public List<String> calculations() {
            if (this.calculations == null) {
                return Collections.emptyList();
            }
            return Stream.of(this.calculations.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public List<String> annexes() {
            if (this.annexes == null) {
                return Collections.emptyList();
            }
            return Stream.of(this.annexes.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public String codeForAnnexes() {
            return this.codeForAnnexes != null ? this.codeForAnnexes : this.code;
        }

        public String annexFilenameOf(String annexName) {
            String filename = this.annexes().stream().filter(a -> a.startsWith(annexName)).map(a -> a.substring(annexName.length() + 1)).findFirst().orElse(null);
            return this.codeForAnnexes() + ANNEX_SEPARATOR + filename + OrderTypes.TEMPLATE_EXTENSION;
        }

        public String templateFilename() {
            return this.code + OrderTypes.TEMPLATE_EXTENSION;
        }

        public String target() {
            return this.target;
        }

        public Channel channel() {
            return this.channel;
        }

        public String assertionCode() {
            return this.assertionCode;
        }

        public Map<String, String> assertionAttrs() {
            return this.assertionAttr;
        }

        public String reportFilename() {
            return this.reportFilename;
        }

        public Checklist checklist() {
            return this.checklist;
        }

        public Map<Checklist.Field, Map<String, String>> triples() {
            return this.triples;
        }

        public String parent() {
            return this.parent;
        }
    }

    public static enum Channel {
        web,
        app,
        both;

    }
}

