/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition.editors;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OptionEdition
extends Edition {
    private final File thesaurusRepository;
    private final String optionsSource;
    protected List<String> options = Collections.emptyList();

    public OptionEdition(String name, FormStore store, Map<String, String> options, Language language) {
        super(name, store, options, language);
        this.thesaurusRepository = new File(options.get("thesaurus-repository"));
        this.optionsSource = options.get("values." + language);
    }

    @Override
    public Edition init() {
        super.init();
        this.options = this.loadOptions();
        return this;
    }

    private List<String> loadOptions() {
        if (!this.isDynamicSource()) {
            return this.toList(this.optionsSource);
        }
        String filename = this.sourceFilename();
        return filename != null ? this.optionsFromFile(filename) : Collections.emptyList();
    }

    protected boolean isDynamicSource() {
        return this.optionsSource.startsWith("@");
    }

    private List<String> optionsFromFile(String filename) {
        try {
            File thesaurus = new File(this.thesaurusRepository + "/" + filename);
            return thesaurus.exists() ? Files.readAllLines(thesaurus.toPath()) : Collections.emptyList();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private String sourceFilename() {
        String[] parts = this.optionsSource.substring(1).split(":");
        return Arrays.stream(parts).map(this::storeValueOf).collect(Collectors.joining(""));
    }

    public List<String> options() {
        return this.options;
    }

    public String get() {
        return (String)this.value();
    }

    public void set(String value) {
        this.store.put(this.name, value);
    }

    private List<String> toList(String values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(values.split(";")).map(String::trim).collect(Collectors.toList());
    }
}

