package io.intino.monet.box.util;

import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.*;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class WorkReportCalculator {
	public Map<String, String> map;
	private final Map<String, XSSFCell> indexes = new HashMap<>();
	private XSSFWorkbook wb;

	public WorkReportCalculator(File file, Map<String, String> map) throws IOException, InvalidFormatException {
		this.wb = new XSSFWorkbook(file);
		map(map);
	}

	public WorkReportCalculator map(Map<String, String> map) {
		this.map = map;
		return this;
	}

	public Map<String, String> update() {
		replace(wb);
		update(wb);
		return map;
	}

	public Map<String, String> update(String key, String value) {
		String parameter = parameter(key);
		if (!indexes.containsKey(parameter)) return map;
		map.put(key, value);
		replace(indexes.get(parameter), parameter);
		update(wb);
		return map;
	}

	private String parameter(String key) {
		return ":" + key + ":";
	}

	private void update(XSSFWorkbook wb) {
		List<XSSFName> names = namesOf(wb);
		FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
		XSSFSheet sheet = wb.getSheetAt(0);
		for (XSSFName name : names) {
			String key = name.getNameName();
			Cell cell = cell(sheet, name.getRefersToFormula());
			String value = valueOf(cell, evaluator);
			put(key, value);
		}
	}

	private List<XSSFName> namesOf(XSSFWorkbook wb) {
		return wb.getAllNames();
	}

	private void put(String key, String value) {
		if (value == null) return;
		map.put(key,value);
	}

	private static final DataFormatter formatter = new DataFormatter();
	private String valueOf(Cell cell, FormulaEvaluator evaluator) {
		if (cell == null) return null;
		return formatter.formatCellValue(cell, evaluator);
	}

	private Cell cell(XSSFSheet sheet, String coordinates) {
		CellReference reference = new CellReference(coordinates);
		Row row = sheet.getRow(reference.getRow());
		return row != null ? row.getCell(reference.getCol()) : null;
	}

	private void replace(XSSFWorkbook wb) {
		XSSFSheet sheet = wb.getSheetAt(0);
		for (int i = sheet.getFirstRowNum(); i < sheet.getLastRowNum(); i++)
			replace(sheet.getRow(i));
	}

	private void replace(XSSFRow row) {
		if(row == null) return;
		for (int j = row.getFirstCellNum(); j < row.getLastCellNum(); j++)
			replace(row.getCell(j));
	}

	private void replace(XSSFCell cell) {
		if (cell == null || cell.getCellType() != CellType.STRING) return;
		replace(cell, cell.getStringCellValue());
	}

	private void replace(XSSFCell cell, String key) {
		if (key.length() < 2 || key.charAt(0) != ':' || key.charAt(key.length() - 1) != ':') return;
		indexes.put(key, cell);
		cell.setCellValue(map.getOrDefault(key.substring(1, key.length()-1),""));
	}

}
