package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.*;
import io.intino.monet.box.*;
import io.intino.monet.box.schemas.*;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.displays.templates.AbstractCheckListWizardStepPackageFile;

import java.net.URL;
import java.util.function.Consumer;

public class CheckListWizardStepPackageFile extends AbstractCheckListWizardStepPackageFile<MonetBox> {
    private Consumer<Resource> changeListener;
    private Consumer<Boolean> uploadingListener;

    public CheckListWizardStepPackageFile(MonetBox box) {
        super(box);
    }

    public void value(URL url) {
        data.value(url);
    }

    public CheckListWizardStepPackageFile onChange(Consumer<Resource> changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public CheckListWizardStepPackageFile onUploading(Consumer<Boolean> listener) {
        this.uploadingListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        data.onUploading(e -> uploadingListener.accept(true));
        data.onChange(e -> changeListener.accept(e.value()));
    }

}