package io.intino.monet.box.ui.displays;

import io.intino.monet.box.MonetBox;
import io.intino.monet.box.schemas.ProgressInfo;

public class ProgressDisplay extends AbstractProgressDisplay<MonetBox> {
    private double value;
    private String label;

    public ProgressDisplay(MonetBox box) {
        super(box);
    }

    public ProgressDisplay value(double value, String label) {
        this.value = value;
        this.label = label;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        notifier.refresh(new ProgressInfo().value(value).label(label));
    }

}