package io.intino.monet.box.ui.displays;

import io.intino.monet.engine.CheckListProvider;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes.Checklist;

import java.util.LinkedHashMap;
import java.util.Map;

import static java.util.Collections.emptyMap;
import static java.util.stream.Collectors.toMap;

public class DisplayHelper {

	public static Map<Checklist.Field, Map<String, String>> checkListTriples(Order order) {
		if (order == null) return emptyMap();
		return checkListTriples(order.code());
	}

	public static Map<Checklist.Field, Map<String, String>> checkListTriples(String orderCode) {
		CheckListProvider provider = new CheckListProvider();
		Map<Checklist.Field, Map<String, String>> triples = provider.findCheckListTriples(orderCode);
		if (triples == null) return emptyMap();
		return triples.entrySet().stream().collect(toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
	}

}
