package io.intino.monet.box.actions;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.schemas.Order;
import io.intino.monet.box.util.SchemaHelper;

import java.time.Instant;
import java.util.Date;

public class PostOrderAction extends MonetAction {
	public MonetBox box;
	public String orderId;
	public String code;
	public String input;
	public String properties;
	public Instant scheduleDate;
	public Instant dueDate;

	public io.intino.monet.box.schemas.Order execute() throws Conflict, BadRequest {
		io.intino.monet.engine.Order order = box.orderApi().create(order());
		if (order == null) throw new Conflict("Order not found");
		return SchemaHelper.schemaOf(order);
	}

	private io.intino.monet.engine.Order order() {
		io.intino.monet.engine.Order result = new io.intino.monet.engine.Order(orderId, code);
		result.input(input);
		result.properties(properties);
		result.createDate(Instant.now());
		result.scheduleDate(scheduleDate);
		result.dueDate(dueDate);
		return result;
	}

}