package io.intino.monet.box;

import io.intino.monet.engine.Order;
import io.intino.monet.engine.WorkReport;

import java.io.File;

public interface OrderFinishedListener {
	void accept(OrderFinishedEvent event);

	class OrderFinishedEvent {
		private Order order;
		private WorkReport report;
		private File reportFile;

		public Order order() {
			return order;
		}

		public OrderFinishedEvent order(Order order) {
			this.order = order;
			return this;
		}

		public WorkReport report() {
			return report;
		}

		public OrderFinishedEvent report(WorkReport report) {
			this.report = report;
			return this;
		}

		public File reportFile() {
			return reportFile;
		}

		public OrderFinishedEvent reportFile(File reportFile) {
			this.reportFile = reportFile;
			return this;
		}
	}
}
