package io.intino.monet.box;

import io.intino.alexandria.office.components.Image;
import io.intino.alexandria.office.components.ImageView;

import static io.intino.alexandria.office.components.ImageView.WrapOption.ClampToPage;
import static io.intino.alexandria.office.components.ImageView.WrapOption.ClampToTemplate;

public interface ImageViewFactory {

    ImageView create(Image image);

    class Default implements ImageViewFactory {

        @Override
        public ImageView create(Image image) {
            ImageView imageView = new ImageView(image);
            imageView.keepAspectRatio(true); // Maintain the aspect ratio of the original image, so it does not get deformed
            if(image.getWidth() >= image.getHeight())
                fixWidthThenAdjustHeight(imageView);
            else
                fixHeightThenAdjustWidth(imageView);
            return imageView;
        }

        private static void fixHeightThenAdjustWidth(ImageView imageView) {
            imageView.widthWrapping(ClampToPage); // Image can be of any width and will not exceed the page's max width
            imageView.heightWrapping(ClampToTemplate); // Image must have the height specified in the template
        }

        private static void fixWidthThenAdjustHeight(ImageView imageView) {
            imageView.widthWrapping(ClampToTemplate); // Image can be of any width and will not exceed the page's max width
            imageView.heightWrapping(ClampToPage); // Image must have the height specified in the template
        }
    }
}
