package io.intino.monet.box.workreports;

import io.intino.monet.box.util.Formatters;
import io.intino.monet.engine.WorkReport;

import java.util.HashMap;
import java.util.Map;

public class WorkReportInfoProvider {
    private WorkReport workReport;

    @SuppressWarnings("unchecked")
    public <T extends WorkReport> T workReport() {
        return (T) workReport;
    }

    public WorkReportInfoProvider workReport(WorkReport workReport) {
        this.workReport = workReport;
        return this;
    }

    public Map<String, String> info() {
        Map<String, String> result = new HashMap<>();
        result.put("date", Formatters.textDate(workReport.finished(), workReport.language()));
        result.put("comments", workReport.comments() == null ? "" : workReport.comments());
        return result;
    }

}
