package io.intino.monet.box.util;

import java.util.Base64;
import java.util.List;
import java.util.function.Function;

import static java.nio.charset.StandardCharsets.UTF_8;

public class HashEncoder {

	public static String encode(String value) {
		return doEncode(reverse(doEncode(value)));
	}

	public static String decode(String hash) {
		return doDecode(reverse(doDecode(hash)));
	}

	private static String reverse(String value) {
		return new StringBuilder(value).reverse().toString();
	}

	private static final List<Function<String, String>> Decoders = List.of(
			hash -> new String(Base64.getDecoder().decode(hash.getBytes(UTF_8)), UTF_8),
			hash -> new String(Base64.getUrlDecoder().decode(hash.getBytes(UTF_8)), UTF_8),
			hash -> new String(io.intino.alexandria.Base64.decode(hash), UTF_8)
	);

	private static String doDecode(String hash) {
		String result = null;
		for (Function<String, String> decoder : Decoders) {
			try {
				result = decoder.apply(hash);
				break;
			} catch (Exception ignored) {
			}
		}
		if (result == null) throw new RuntimeException("Failed to decode hash " + hash);
		return result;
	}

	private static String doEncode(String value) {
		return Base64.getEncoder().encodeToString(value.getBytes(UTF_8));
	}
}
