package io.intino.monet.box.util;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import java.util.Locale;

public class Formatters {

	private static final String SecondsFormat = "yyyyMMddHHmmss";
	private static final String TextDayFormat = "dd 'of' MMMM 'of' yyyy";

	public static Instant instantOf(LocalDate date) {
		return Instant.ofEpochSecond(date.toEpochDay()*24*60*60);
	}

	public static String countMessage(int count, String singleLabel, String pluralLabel, String language) {
		return countMessage((long)count, singleLabel, pluralLabel, language);
	}

	public static String countMessage(long count, String singleLabel, String pluralLabel, String language) {
		if (count == 0) return io.intino.monet.box.I18n.translate("No " + pluralLabel, language);
		if (count == 1) return "1 " + io.intino.monet.box.I18n.translate(singleLabel, language);
		return formattedNumber(count, language) + " " + io.intino.monet.box.I18n.translate(pluralLabel, language);
	}

	public static String formattedNumber(long value, String language) {
		return formattedNumber(value, Locale.forLanguageTag(language));
	}

	public static String formattedNumber(long value, Locale locale) {
		return NumberFormat.getNumberInstance(locale).format(value);
	}

	public static String dateWithSeconds(Instant date) {
		if (date == null) return null;
		SimpleDateFormat format = new SimpleDateFormat(SecondsFormat);
		return format.format(Date.from(date));
	}

	public static String textDate(Instant date, String language) {
		return date(date, textDayFormat(language), language);
	}

	public static String date(Instant date, String format, String language) {
		if (date == null) return null;
		return formatDate(format, date, locale(language));
	}

	private static String formatDate(String pattern, Instant instant, Locale locale) {
		SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
		return format.format(Date.from(instant));
	}

	private static Locale locale(String language) {
		if (language.toLowerCase().contains("es")) return new Locale("es", "ES");
		if (language.toLowerCase().contains("pt")) return new Locale("pt", "PT");
		return new Locale("en", "EN");
	}

	private static String textDayFormat(String language) {
		if (language.toLowerCase().contains("es")) return "dd 'de' MMMM 'de' YYYY";
		if (language.toLowerCase().contains("pt")) return "dd 'de' MMMM 'de' YYYY";
		return "dd 'of' MMMM 'of' yyyy";
	}
}
