package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.ui.displays.components.*;
import io.intino.monet.box.ui.*;

import io.intino.monet.box.MonetBox;

import io.intino.monet.box.ui.displays.templates.*;






import io.intino.monet.box.ui.displays.items.*;

import io.intino.monet.box.ui.displays.notifiers.OrderTemplateNotifier;

public abstract class AbstractOrderTemplate<DN extends OrderTemplateNotifier, B extends Box> extends io.intino.alexandria.ui.displays.components.Template<DN, java.lang.Void, B> {
	public OrderNotFoundBlock orderNotFoundBlock;
	public OrderTemplate.OrderNotFoundBlock. _35_2_01934277178 _35_2_01934277178;
	public OrderFoundBlock orderFoundBlock;
	public OrderTemplate.OrderFoundBlock. _37_2_0832248981 _37_2_0832248981;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981. ToolbarBlock toolbarBlock;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock. ViewSelector viewSelector;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock.ViewSelector. PreviewOption previewOption;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock.ViewSelector. IndexOption indexOption;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock.ViewSelector. EditionOption editionOption;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981. _43_3_1771935227 _43_3_1771935227;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227. PreviewBlock previewBlock;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.PreviewBlock. WorkReportPreview workReportPreview;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227. IndexBlock indexBlock;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.IndexBlock. _47_5_01579543551 _47_5_01579543551;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.IndexBlock. IndexEntriesBlock indexEntriesBlock;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.IndexBlock.IndexEntriesBlock. IndexEntries indexEntries;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227. EditionBlock editionBlock;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock. OrderInfo orderInfo;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock. StepBlock stepBlock;
	public CheckListWizardStep stepStamp;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock. FinalBlock finalBlock;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock.FinalBlock. _54_6_12054240653 _54_6_12054240653;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock.FinalBlock. ViewWorkReport viewWorkReport;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock.FinalBlock. ViewIndex viewIndex;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981. Progress progress;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981. GeneratingMessage generatingMessage;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981.GeneratingMessage. _59_98_01131215905 _59_98_01131215905;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981. SavedMessage savedMessage;
	public OrderTemplate.OrderFoundBlock._37_2_0832248981.SavedMessage. _60_89_11135151154 _60_89_11135151154;
	public OrderTemplate.OrderFoundBlock. _61_2_1955995399 _61_2_1955995399;
	public OrderTemplate.OrderFoundBlock. _62_2_11233311472 _62_2_11233311472;
	public OrderTemplate.OrderFoundBlock._62_2_11233311472. _63_3_0429925972 _63_3_0429925972;
	public OrderTemplate.OrderFoundBlock._62_2_11233311472._63_3_0429925972. RestartOrder restartOrder;
	public OrderTemplate.OrderFoundBlock._62_2_11233311472. _65_3_01878370145 _65_3_01878370145;
	public OrderTemplate.OrderFoundBlock._62_2_11233311472._65_3_01878370145. PreviousStep previousStep;
	public OrderTemplate.OrderFoundBlock._62_2_11233311472._65_3_01878370145. NextStep nextStep;
	public OrderTemplate.OrderFoundBlock._62_2_11233311472._65_3_01878370145. TerminateOrder terminateOrder;
	public OrderCompletedBlock orderCompletedBlock;
	public OrderTemplate.OrderCompletedBlock. _70_2_01475946838 _70_2_01475946838;

    public AbstractOrderTemplate(B box) {
        super(box);
        id("orderTemplate");
    }

    @Override
	public void init() {
		super.init();
		if (orderNotFoundBlock == null) orderNotFoundBlock = register(new OrderNotFoundBlock(box()).<OrderNotFoundBlock>id("a1578997958").owner(AbstractOrderTemplate.this));
		if (orderNotFoundBlock != null) _35_2_01934277178 = orderNotFoundBlock._35_2_01934277178;
		if (orderFoundBlock == null) orderFoundBlock = register(new OrderFoundBlock(box()).<OrderFoundBlock>id("a1758623683").owner(AbstractOrderTemplate.this));
		if (orderFoundBlock != null) _37_2_0832248981 = orderFoundBlock._37_2_0832248981;
		if (_37_2_0832248981 != null) toolbarBlock = orderFoundBlock._37_2_0832248981.toolbarBlock;
		if (toolbarBlock != null) viewSelector = orderFoundBlock._37_2_0832248981.toolbarBlock.viewSelector;
		if (viewSelector != null) previewOption = orderFoundBlock._37_2_0832248981.toolbarBlock.viewSelector.previewOption;
		if (viewSelector != null) indexOption = orderFoundBlock._37_2_0832248981.toolbarBlock.viewSelector.indexOption;
		if (viewSelector != null) editionOption = orderFoundBlock._37_2_0832248981.toolbarBlock.viewSelector.editionOption;
		if (_37_2_0832248981 != null) _43_3_1771935227 = orderFoundBlock._37_2_0832248981._43_3_1771935227;
		if (_43_3_1771935227 != null) previewBlock = orderFoundBlock._37_2_0832248981._43_3_1771935227.previewBlock;
		if (previewBlock != null) workReportPreview = orderFoundBlock._37_2_0832248981._43_3_1771935227.previewBlock.workReportPreview;
		if (_43_3_1771935227 != null) indexBlock = orderFoundBlock._37_2_0832248981._43_3_1771935227.indexBlock;
		if (indexBlock != null) _47_5_01579543551 = orderFoundBlock._37_2_0832248981._43_3_1771935227.indexBlock._47_5_01579543551;
		if (indexBlock != null) indexEntriesBlock = orderFoundBlock._37_2_0832248981._43_3_1771935227.indexBlock.indexEntriesBlock;
		if (indexEntriesBlock != null) indexEntries = orderFoundBlock._37_2_0832248981._43_3_1771935227.indexBlock.indexEntriesBlock.indexEntries;
		if (_43_3_1771935227 != null) editionBlock = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock;
		if (editionBlock != null) orderInfo = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.orderInfo;
		if (editionBlock != null) stepBlock = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.stepBlock;
		if (stepBlock != null) stepStamp = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.stepBlock.stepStamp;
		if (editionBlock != null) finalBlock = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.finalBlock;
		if (finalBlock != null) _54_6_12054240653 = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.finalBlock._54_6_12054240653;
		if (finalBlock != null) viewWorkReport = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.finalBlock.viewWorkReport;
		if (finalBlock != null) viewIndex = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.finalBlock.viewIndex;
		if (_37_2_0832248981 != null) progress = orderFoundBlock._37_2_0832248981.progress;
		if (_37_2_0832248981 != null) generatingMessage = orderFoundBlock._37_2_0832248981.generatingMessage;
		if (generatingMessage != null) _59_98_01131215905 = orderFoundBlock._37_2_0832248981.generatingMessage._59_98_01131215905;
		if (_37_2_0832248981 != null) savedMessage = orderFoundBlock._37_2_0832248981.savedMessage;
		if (savedMessage != null) _60_89_11135151154 = orderFoundBlock._37_2_0832248981.savedMessage._60_89_11135151154;
		if (orderFoundBlock != null) _61_2_1955995399 = orderFoundBlock._61_2_1955995399;
		if (orderFoundBlock != null) _62_2_11233311472 = orderFoundBlock._62_2_11233311472;
		if (_62_2_11233311472 != null) _63_3_0429925972 = orderFoundBlock._62_2_11233311472._63_3_0429925972;
		if (_63_3_0429925972 != null) restartOrder = orderFoundBlock._62_2_11233311472._63_3_0429925972.restartOrder;
		if (_62_2_11233311472 != null) _65_3_01878370145 = orderFoundBlock._62_2_11233311472._65_3_01878370145;
		if (_65_3_01878370145 != null) previousStep = orderFoundBlock._62_2_11233311472._65_3_01878370145.previousStep;
		if (_65_3_01878370145 != null) nextStep = orderFoundBlock._62_2_11233311472._65_3_01878370145.nextStep;
		if (_65_3_01878370145 != null) terminateOrder = orderFoundBlock._62_2_11233311472._65_3_01878370145.terminateOrder;
		if (orderCompletedBlock == null) orderCompletedBlock = register(new OrderCompletedBlock(box()).<OrderCompletedBlock>id("a_1552588134").owner(AbstractOrderTemplate.this));
		if (orderCompletedBlock != null) _70_2_01475946838 = orderCompletedBlock._70_2_01475946838;



		if (previewBlock != null) previewBlock.bindTo(viewSelector, "previewOption");
		if (indexBlock != null) indexBlock.bindTo(viewSelector, "indexOption");
		if (editionBlock != null) editionBlock.bindTo(viewSelector, "editionOption");
	}

    @Override
    public void remove() {
        super.remove();
	    if (orderNotFoundBlock != null) orderNotFoundBlock.unregister();
	    if (orderFoundBlock != null) orderFoundBlock.unregister();
	    if (orderCompletedBlock != null) orderCompletedBlock.unregister();
	}

	public class OrderNotFoundBlock extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
		public OrderTemplate.OrderNotFoundBlock. _35_2_01934277178 _35_2_01934277178;

		public OrderNotFoundBlock(B box) {
			super(box);
		}

		@Override
		public void init() {
			super.init();
			if (_35_2_01934277178 == null) _35_2_01934277178 = register(new _35_2_01934277178(box()).<_35_2_01934277178>id("a1399398005").owner(AbstractOrderTemplate.this));
		}

		@Override
		public void unregister() {
		    super.unregister();
			if (_35_2_01934277178 != null) _35_2_01934277178.unregister();
		}

		public class _35_2_01934277178 extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B>  {

			public _35_2_01934277178(B box) {
				super(box);
				_value("Order not found");
			}

			@Override
			public void init() {
				super.init();
			}

			@Override
			public void unregister() {
			    super.unregister();
			}
		}
	}

	public class OrderFoundBlock extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
		public OrderTemplate.OrderFoundBlock. _37_2_0832248981 _37_2_0832248981;
		public OrderTemplate.OrderFoundBlock. _61_2_1955995399 _61_2_1955995399;
		public OrderTemplate.OrderFoundBlock. _62_2_11233311472 _62_2_11233311472;

		public OrderFoundBlock(B box) {
			super(box);
		}

		@Override
		public void init() {
			super.init();
			if (_37_2_0832248981 == null) _37_2_0832248981 = register(new _37_2_0832248981(box()).<_37_2_0832248981>id("a_1841606904").owner(AbstractOrderTemplate.this));
			if (_61_2_1955995399 == null) _61_2_1955995399 = register(new _61_2_1955995399(box()).<_61_2_1955995399>id("a1473555988").owner(AbstractOrderTemplate.this));
			if (_62_2_11233311472 == null) _62_2_11233311472 = register(new _62_2_11233311472(box()).<_62_2_11233311472>id("a_2048557535").owner(AbstractOrderTemplate.this));
		}

		@Override
		public void unregister() {
		    super.unregister();
			if (_37_2_0832248981 != null) _37_2_0832248981.unregister();
			if (_61_2_1955995399 != null) _61_2_1955995399.unregister();
			if (_62_2_11233311472 != null) _62_2_11233311472.unregister();
		}

		public class _37_2_0832248981 extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
			public OrderTemplate.OrderFoundBlock._37_2_0832248981. ToolbarBlock toolbarBlock;
			public OrderTemplate.OrderFoundBlock._37_2_0832248981. _43_3_1771935227 _43_3_1771935227;
			public OrderTemplate.OrderFoundBlock._37_2_0832248981. Progress progress;
			public OrderTemplate.OrderFoundBlock._37_2_0832248981. GeneratingMessage generatingMessage;
			public OrderTemplate.OrderFoundBlock._37_2_0832248981. SavedMessage savedMessage;

			public _37_2_0832248981(B box) {
				super(box);
			}

			@Override
			public void init() {
				super.init();
				if (toolbarBlock == null) toolbarBlock = register(new ToolbarBlock(box()).<ToolbarBlock>id("a1043246377").owner(AbstractOrderTemplate.this));
				if (_43_3_1771935227 == null) _43_3_1771935227 = register(new _43_3_1771935227(box()).<_43_3_1771935227>id("a656470560").owner(AbstractOrderTemplate.this));
				if (progress == null) progress = AbstractOrderTemplate.this.progress = register(new Progress(box()).<Progress>id("a1118467332").owner(AbstractOrderTemplate.this));
				if (generatingMessage == null) generatingMessage = register(new GeneratingMessage(box()).<GeneratingMessage>id("a517663166").owner(AbstractOrderTemplate.this));
				if (savedMessage == null) savedMessage = register(new SavedMessage(box()).<SavedMessage>id("a1282048727").owner(AbstractOrderTemplate.this));
			}

			@Override
			public void unregister() {
			    super.unregister();
				if (toolbarBlock != null) toolbarBlock.unregister();
				if (_43_3_1771935227 != null) _43_3_1771935227.unregister();
				if (progress != null) progress.unregister();
				if (generatingMessage != null) generatingMessage.unregister();
				if (savedMessage != null) savedMessage.unregister();
			}

			public class ToolbarBlock extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
				public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock. ViewSelector viewSelector;

				public ToolbarBlock(B box) {
					super(box);
				}

				@Override
				public void init() {
					super.init();
					if (viewSelector == null) viewSelector = register(new ViewSelector(box()).<ViewSelector>id("a_2108668678").owner(AbstractOrderTemplate.this));
				}

				@Override
				public void unregister() {
				    super.unregister();
					if (viewSelector != null) viewSelector.unregister();
				}

				public class ViewSelector extends io.intino.alexandria.ui.displays.components.SelectorTabs<io.intino.alexandria.ui.displays.notifiers.SelectorTabsNotifier, B>  {
					public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock.ViewSelector. PreviewOption previewOption;
					public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock.ViewSelector. IndexOption indexOption;
					public OrderTemplate.OrderFoundBlock._37_2_0832248981.ToolbarBlock.ViewSelector. EditionOption editionOption;

					public ViewSelector(B box) {
						super(box);
						_multipleSelection(false);
					}

					@Override
					public void init() {
						super.init();
						if (previewOption == null) previewOption = register(new PreviewOption(box()).<PreviewOption>id("a515718104").owner(AbstractOrderTemplate.this));
						if (indexOption == null) indexOption = register(new IndexOption(box()).<IndexOption>id("a1744057378").owner(AbstractOrderTemplate.this));
						if (editionOption == null) editionOption = register(new EditionOption(box()).<EditionOption>id("a286817614").owner(AbstractOrderTemplate.this));
					}

					@Override
					public void unregister() {
					    super.unregister();
						if (previewOption != null) previewOption.unregister();
						if (indexOption != null) indexOption.unregister();
						if (editionOption != null) editionOption.unregister();
					}

					public class PreviewOption extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B> implements io.intino.alexandria.ui.displays.components.selector.SelectorOption {

						public PreviewOption(B box) {
							super(box);

							name("previewOption");
							_value("Preview");
						}

						@Override
						public void init() {
							super.init();
						}

						@Override
						public void unregister() {
						    super.unregister();
						}
					}

					public class IndexOption extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B> implements io.intino.alexandria.ui.displays.components.selector.SelectorOption {

						public IndexOption(B box) {
							super(box);

							name("indexOption");
							_value("Index");
						}

						@Override
						public void init() {
							super.init();
						}

						@Override
						public void unregister() {
						    super.unregister();
						}
					}

					public class EditionOption extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B> implements io.intino.alexandria.ui.displays.components.selector.SelectorOption {

						public EditionOption(B box) {
							super(box);

							name("editionOption");
							_value("Edition");
						}

						@Override
						public void init() {
							super.init();
						}

						@Override
						public void unregister() {
						    super.unregister();
						}
					}
				}
			}

			public class _43_3_1771935227 extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
				public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227. PreviewBlock previewBlock;
				public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227. IndexBlock indexBlock;
				public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227. EditionBlock editionBlock;

				public _43_3_1771935227(B box) {
					super(box);
				}

				@Override
				public void init() {
					super.init();
					if (previewBlock == null) previewBlock = register(new PreviewBlock(box()).<PreviewBlock>id("a2104339744").owner(AbstractOrderTemplate.this));
					if (indexBlock == null) indexBlock = register(new IndexBlock(box()).<IndexBlock>id("a1152819478").owner(AbstractOrderTemplate.this));
					if (editionBlock == null) editionBlock = register(new EditionBlock(box()).<EditionBlock>id("a_1366727446").owner(AbstractOrderTemplate.this));
				}

				@Override
				public void unregister() {
				    super.unregister();
					if (previewBlock != null) previewBlock.unregister();
					if (indexBlock != null) indexBlock.unregister();
					if (editionBlock != null) editionBlock.unregister();
				}

				public class PreviewBlock extends io.intino.alexandria.ui.displays.components.BlockConditional<io.intino.alexandria.ui.displays.notifiers.BlockConditionalNotifier, B>  {
					public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.PreviewBlock. WorkReportPreview workReportPreview;

					public PreviewBlock(B box) {
						super(box);
					}

					@Override
					public void initConditional() {
						super.init();
						if (workReportPreview == null) workReportPreview = register(new WorkReportPreview(box()).<WorkReportPreview>id("a1208049412").owner(AbstractOrderTemplate.this));
						if (AbstractOrderTemplate.this.workReportPreview == null) AbstractOrderTemplate.this.workReportPreview = orderFoundBlock._37_2_0832248981._43_3_1771935227.previewBlock.workReportPreview;
					}

					@Override
					public void unregister() {
					    super.unregister();
						if (workReportPreview != null) workReportPreview.unregister();
					}

					public class WorkReportPreview extends io.intino.alexandria.ui.displays.components.File<io.intino.alexandria.ui.displays.notifiers.FileNotifier, B>  {

						public WorkReportPreview(B box) {
							super(box);
						}

						@Override
						public void init() {
							super.init();
						}

						@Override
						public void unregister() {
						    super.unregister();
						}
					}
				}

				public class IndexBlock extends io.intino.alexandria.ui.displays.components.BlockConditional<io.intino.alexandria.ui.displays.notifiers.BlockConditionalNotifier, B>  {
					public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.IndexBlock. _47_5_01579543551 _47_5_01579543551;
					public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.IndexBlock. IndexEntriesBlock indexEntriesBlock;

					public IndexBlock(B box) {
						super(box);
					}

					@Override
					public void initConditional() {
						super.init();
						if (_47_5_01579543551 == null) _47_5_01579543551 = register(new _47_5_01579543551(box()).<_47_5_01579543551>id("a2059737347").owner(AbstractOrderTemplate.this));
						if (indexEntriesBlock == null) indexEntriesBlock = register(new IndexEntriesBlock(box()).<IndexEntriesBlock>id("a_1768149786").owner(AbstractOrderTemplate.this));
						if (AbstractOrderTemplate.this._47_5_01579543551 == null) AbstractOrderTemplate.this._47_5_01579543551 = orderFoundBlock._37_2_0832248981._43_3_1771935227.indexBlock._47_5_01579543551;
						if (AbstractOrderTemplate.this.indexEntries == null) AbstractOrderTemplate.this.indexEntries = orderFoundBlock._37_2_0832248981._43_3_1771935227.indexBlock.indexEntriesBlock.indexEntries;
					}

					@Override
					public void unregister() {
					    super.unregister();
						if (_47_5_01579543551 != null) _47_5_01579543551.unregister();
						if (indexEntriesBlock != null) indexEntriesBlock.unregister();
					}

					public class _47_5_01579543551 extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B>  {

						public _47_5_01579543551(B box) {
							super(box);
							_value("Index");
						}

						@Override
						public void init() {
							super.init();
						}

						@Override
						public void unregister() {
						    super.unregister();
						}
					}

					public class IndexEntriesBlock extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
						public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.IndexBlock.IndexEntriesBlock. IndexEntries indexEntries;

						public IndexEntriesBlock(B box) {
							super(box);
						}

						@Override
						public void init() {
							super.init();
							if (indexEntries == null) indexEntries = AbstractOrderTemplate.this.indexEntries = register(new IndexEntries(box()).<IndexEntries>id("a1495770647").owner(AbstractOrderTemplate.this));
						}

						@Override
						public void unregister() {
						    super.unregister();
							if (indexEntries != null) indexEntries.unregister();
						}

						public class IndexEntries extends io.intino.alexandria.ui.displays.components.Multiple<Box,CheckListWizardIndexEntry, java.lang.Void> implements io.intino.alexandria.ui.displays.components.multiple.NonCollapsable<Box,CheckListWizardIndexEntry, java.lang.Void> {

							public IndexEntries(Box box) {
								super(box);
							}

							@Override
							public void init() {
								super.init();
							}

							@Override
							public void unregister() {
							    super.unregister();
							}

							@Override
							public CheckListWizardIndexEntry add(java.lang.Void value) {
								CheckListWizardIndexEntry child = new CheckListWizardIndexEntry(box());
								child.id(java.util.UUID.randomUUID().toString());
								add(child, "indexEntries");
							    notifyAdd(child);
								return child;
							}
							@Override
							public void remove(CheckListWizardIndexEntry child) {
								removeChild(child, "indexEntries");
							}
							public void clear() {
							    super.clear("indexEntries");
							}
						}
					}
				}

				public class EditionBlock extends io.intino.alexandria.ui.displays.components.BlockConditional<io.intino.alexandria.ui.displays.notifiers.BlockConditionalNotifier, B>  {
					public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock. OrderInfo orderInfo;
					public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock. StepBlock stepBlock;
					public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock. FinalBlock finalBlock;

					public EditionBlock(B box) {
						super(box);
					}

					@Override
					public void initConditional() {
						super.init();
						if (orderInfo == null) orderInfo = register(new OrderInfo(box()).<OrderInfo>id("a_703804409").owner(AbstractOrderTemplate.this));
						if (stepBlock == null) stepBlock = register(new StepBlock(box()).<StepBlock>id("a1006104588").owner(AbstractOrderTemplate.this));
						if (finalBlock == null) finalBlock = register(new FinalBlock(box()).<FinalBlock>id("a1327638316").owner(AbstractOrderTemplate.this));
						if (AbstractOrderTemplate.this.orderInfo == null) AbstractOrderTemplate.this.orderInfo = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.orderInfo;
						if (AbstractOrderTemplate.this.stepStamp == null) AbstractOrderTemplate.this.stepStamp = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.stepBlock.stepStamp;
						if (AbstractOrderTemplate.this._54_6_12054240653 == null) AbstractOrderTemplate.this._54_6_12054240653 = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.finalBlock._54_6_12054240653;
						if (AbstractOrderTemplate.this.viewWorkReport == null) AbstractOrderTemplate.this.viewWorkReport = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.finalBlock.viewWorkReport;
						if (AbstractOrderTemplate.this.viewIndex == null) AbstractOrderTemplate.this.viewIndex = orderFoundBlock._37_2_0832248981._43_3_1771935227.editionBlock.finalBlock.viewIndex;
					}

					@Override
					public void unregister() {
					    super.unregister();
						if (orderInfo != null) orderInfo.unregister();
						if (stepBlock != null) stepBlock.unregister();
						if (finalBlock != null) finalBlock.unregister();
					}

					public class OrderInfo extends io.intino.alexandria.ui.displays.components.TextCode<io.intino.alexandria.ui.displays.notifiers.TextCodeNotifier, B>  {

						public OrderInfo(B box) {
							super(box);
						}

						@Override
						public void init() {
							super.init();
						}

						@Override
						public void unregister() {
						    super.unregister();
						}
					}

					public class StepBlock extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
						public CheckListWizardStep stepStamp;

						public StepBlock(B box) {
							super(box);
						}

						@Override
						public void init() {
							super.init();
							if (stepStamp == null) stepStamp = AbstractOrderTemplate.this.stepStamp = register(new CheckListWizardStep(box()).id("a1279752164"));
						}

						@Override
						public void unregister() {
						    super.unregister();
							if (stepStamp != null) stepStamp.unregister();
						}
					}

					public class FinalBlock extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
						public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock.FinalBlock. _54_6_12054240653 _54_6_12054240653;
						public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock.FinalBlock. ViewWorkReport viewWorkReport;
						public OrderTemplate.OrderFoundBlock._37_2_0832248981._43_3_1771935227.EditionBlock.FinalBlock. ViewIndex viewIndex;

						public FinalBlock(B box) {
							super(box);
						}

						@Override
						public void init() {
							super.init();
							if (_54_6_12054240653 == null) _54_6_12054240653 = register(new _54_6_12054240653(box()).<_54_6_12054240653>id("a1161346775").owner(AbstractOrderTemplate.this));
							if (viewWorkReport == null) viewWorkReport = register(new ViewWorkReport(box()).<ViewWorkReport>id("a219876765").owner(AbstractOrderTemplate.this));
							if (viewIndex == null) viewIndex = register(new ViewIndex(box()).<ViewIndex>id("a57800666").owner(AbstractOrderTemplate.this));
						}

						@Override
						public void unregister() {
						    super.unregister();
							if (_54_6_12054240653 != null) _54_6_12054240653.unregister();
							if (viewWorkReport != null) viewWorkReport.unregister();
							if (viewIndex != null) viewIndex.unregister();
						}

						public class _54_6_12054240653 extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B>  {

							public _54_6_12054240653(B box) {
								super(box);
								_value("Congratulations! you have finished order");
							}

							@Override
							public void init() {
								super.init();
							}

							@Override
							public void unregister() {
							    super.unregister();
							}
						}

						public class ViewWorkReport extends io.intino.alexandria.ui.displays.components.Action<io.intino.alexandria.ui.displays.notifiers.ActionNotifier, B>  {

							public ViewWorkReport(B box) {
								super(box);
								_title("View work report");
								_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Link"));
							}

							@Override
							public void init() {
								super.init();
							}

							@Override
							public void unregister() {
							    super.unregister();
							}
						}

						public class ViewIndex extends io.intino.alexandria.ui.displays.components.Action<io.intino.alexandria.ui.displays.notifiers.ActionNotifier, B>  {

							public ViewIndex(B box) {
								super(box);
								_title("View index");
								_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Link"));
							}

							@Override
							public void init() {
								super.init();
							}

							@Override
							public void unregister() {
							    super.unregister();
							}
						}
					}
				}
			}

			public class Progress extends io.intino.alexandria.ui.displays.components.DisplayStamp<io.intino.alexandria.ui.displays.notifiers.DisplayStampNotifier, B>  {

				public Progress(B box) {
					super(box);
				}

				@Override
				public void init() {
					super.init();
				}

				@Override
				public void unregister() {
				    super.unregister();
				}
			}

			public class GeneratingMessage extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
				public OrderTemplate.OrderFoundBlock._37_2_0832248981.GeneratingMessage. _59_98_01131215905 _59_98_01131215905;

				public GeneratingMessage(B box) {
					super(box);
				}

				@Override
				public void init() {
					super.init();
					if (_59_98_01131215905 == null) _59_98_01131215905 = register(new _59_98_01131215905(box()).<_59_98_01131215905>id("a_124080109").owner(AbstractOrderTemplate.this));
				}

				@Override
				public void unregister() {
				    super.unregister();
					if (_59_98_01131215905 != null) _59_98_01131215905.unregister();
				}

				public class _59_98_01131215905 extends io.intino.alexandria.ui.displays.components.Spinner<io.intino.alexandria.ui.displays.notifiers.SpinnerNotifier, B>  {

					public _59_98_01131215905(B box) {
						super(box);
					}

					@Override
					public void init() {
						super.init();
					}

					@Override
					public void unregister() {
					    super.unregister();
					}
				}
			}

			public class SavedMessage extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
				public OrderTemplate.OrderFoundBlock._37_2_0832248981.SavedMessage. _60_89_11135151154 _60_89_11135151154;

				public SavedMessage(B box) {
					super(box);
				}

				@Override
				public void init() {
					super.init();
					if (_60_89_11135151154 == null) _60_89_11135151154 = register(new _60_89_11135151154(box()).<_60_89_11135151154>id("a_1731859802").owner(AbstractOrderTemplate.this));
				}

				@Override
				public void unregister() {
				    super.unregister();
					if (_60_89_11135151154 != null) _60_89_11135151154.unregister();
				}

				public class _60_89_11135151154 extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B>  {

					public _60_89_11135151154(B box) {
						super(box);
						_value("Order saved");
					}

					@Override
					public void init() {
						super.init();
					}

					@Override
					public void unregister() {
					    super.unregister();
					}
				}
			}
		}

		public class _61_2_1955995399 extends io.intino.alexandria.ui.displays.components.Divider<io.intino.alexandria.ui.displays.notifiers.DividerNotifier, B>  {

			public _61_2_1955995399(B box) {
				super(box);
			}

			@Override
			public void init() {
				super.init();
			}

			@Override
			public void unregister() {
			    super.unregister();
			}
		}

		public class _62_2_11233311472 extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
			public OrderTemplate.OrderFoundBlock._62_2_11233311472. _63_3_0429925972 _63_3_0429925972;
			public OrderTemplate.OrderFoundBlock._62_2_11233311472. _65_3_01878370145 _65_3_01878370145;

			public _62_2_11233311472(B box) {
				super(box);
			}

			@Override
			public void init() {
				super.init();
				if (_63_3_0429925972 == null) _63_3_0429925972 = register(new _63_3_0429925972(box()).<_63_3_0429925972>id("a1763751473").owner(AbstractOrderTemplate.this));
				if (_65_3_01878370145 == null) _65_3_01878370145 = register(new _65_3_01878370145(box()).<_65_3_01878370145>id("a143618130").owner(AbstractOrderTemplate.this));
			}

			@Override
			public void unregister() {
			    super.unregister();
				if (_63_3_0429925972 != null) _63_3_0429925972.unregister();
				if (_65_3_01878370145 != null) _65_3_01878370145.unregister();
			}

			public class _63_3_0429925972 extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
				public OrderTemplate.OrderFoundBlock._62_2_11233311472._63_3_0429925972. RestartOrder restartOrder;

				public _63_3_0429925972(B box) {
					super(box);
				}

				@Override
				public void init() {
					super.init();
					if (restartOrder == null) restartOrder = register(new RestartOrder(box()).<RestartOrder>id("a1044760060").owner(AbstractOrderTemplate.this));
				}

				@Override
				public void unregister() {
				    super.unregister();
					if (restartOrder != null) restartOrder.unregister();
				}

				public class RestartOrder extends io.intino.alexandria.ui.displays.components.Action<io.intino.alexandria.ui.displays.notifiers.ActionNotifier, B>  {

					public RestartOrder(B box) {
						super(box);
						_title("Restart");
						_readonly(true);
						_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Button"));
					}

					@Override
					public void init() {
						super.init();
					}

					@Override
					public void unregister() {
					    super.unregister();
					}
				}
			}

			public class _65_3_01878370145 extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
				public OrderTemplate.OrderFoundBlock._62_2_11233311472._65_3_01878370145. PreviousStep previousStep;
				public OrderTemplate.OrderFoundBlock._62_2_11233311472._65_3_01878370145. NextStep nextStep;
				public OrderTemplate.OrderFoundBlock._62_2_11233311472._65_3_01878370145. TerminateOrder terminateOrder;

				public _65_3_01878370145(B box) {
					super(box);
				}

				@Override
				public void init() {
					super.init();
					if (previousStep == null) previousStep = register(new PreviousStep(box()).<PreviousStep>id("a_232719970").owner(AbstractOrderTemplate.this));
					if (nextStep == null) nextStep = register(new NextStep(box()).<NextStep>id("a_2085928678").owner(AbstractOrderTemplate.this));
					if (terminateOrder == null) terminateOrder = register(new TerminateOrder(box()).<TerminateOrder>id("a542237160").owner(AbstractOrderTemplate.this));
				}

				@Override
				public void unregister() {
				    super.unregister();
					if (previousStep != null) previousStep.unregister();
					if (nextStep != null) nextStep.unregister();
					if (terminateOrder != null) terminateOrder.unregister();
				}

				public class PreviousStep extends io.intino.alexandria.ui.displays.components.Action<io.intino.alexandria.ui.displays.notifiers.ActionNotifier, B>  {

					public PreviousStep(B box) {
						super(box);
						_title("Previous");
						_readonly(true);
						_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Button"));
					}

					@Override
					public void init() {
						super.init();
					}

					@Override
					public void unregister() {
					    super.unregister();
					}
				}

				public class NextStep extends io.intino.alexandria.ui.displays.components.Action<io.intino.alexandria.ui.displays.notifiers.ActionNotifier, B>  {

					public NextStep(B box) {
						super(box);
						_title("Next");
						_readonly(true);
						_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Button"));
					}

					@Override
					public void init() {
						super.init();
					}

					@Override
					public void unregister() {
					    super.unregister();
					}
				}

				public class TerminateOrder extends io.intino.alexandria.ui.displays.components.Action<io.intino.alexandria.ui.displays.notifiers.ActionNotifier, B>  {

					public TerminateOrder(B box) {
						super(box);
						_title("Finish");
						_mode(io.intino.alexandria.ui.displays.components.Actionable.Mode.valueOf("Button"));
					}

					@Override
					public void init() {
						super.init();
					}

					@Override
					public void unregister() {
					    super.unregister();
					}
				}
			}
		}
	}

	public class OrderCompletedBlock extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
		public OrderTemplate.OrderCompletedBlock. _70_2_01475946838 _70_2_01475946838;

		public OrderCompletedBlock(B box) {
			super(box);
		}

		@Override
		public void init() {
			super.init();
			if (_70_2_01475946838 == null) _70_2_01475946838 = register(new _70_2_01475946838(box()).<_70_2_01475946838>id("a1756630650").owner(AbstractOrderTemplate.this));
		}

		@Override
		public void unregister() {
		    super.unregister();
			if (_70_2_01475946838 != null) _70_2_01475946838.unregister();
		}

		public class _70_2_01475946838 extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B>  {

			public _70_2_01475946838(B box) {
				super(box);
				_value("Order finished. Congratulations!");
			}

			@Override
			public void init() {
				super.init();
			}

			@Override
			public void unregister() {
			    super.unregister();
			}
		}
	}
}