package io.intino.monet.box.ui.displays;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.util.OrderHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.edition.Field;
import io.intino.monet.engine.edition.Form;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;

public class AttachmentRenderer extends AbstractAttachmentRenderer<MonetBox> {
    private Order order;
    private Form form;
    private Field field;
    private File attachment;

    public AttachmentRenderer(MonetBox box) {
        super(box);
    }

    public AttachmentRenderer order(Order order) {
        this.order = order;
        return this;
    }

    public AttachmentRenderer form(Form form) {
        this.form = form;
        return this;
    }

    public AttachmentRenderer field(Field field) {
        this.field = field;
        return this;
    }

    public AttachmentRenderer attachment(File attachment) {
        this.attachment = attachment;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        notifier.refresh(content());
    }

    private String content() {
        try {
            if (attachment == null || !attachment.exists()) return "";
            Map<String, String> values = OrderHelper.valuesOf(order, form);
            values.put("base-url", baseUrl());
            return OrderHelper.replaceVariables(Files.readString(attachment.toPath()), values);
        } catch (IOException e) {
            Logger.error(e);
            return "";
        }
    }

    private String baseUrl() {
        String url = session().browser().baseUrl();
        url = url.replace("://", "#BAR#");
        url = url.contains("/") ? url.split("/")[0] : url;
        return url.replace("#BAR#", "://");
    }

}