package io.intino.monet.box.actions;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.OrderApi;
import io.intino.monet.box.commands.order.ResolveOrderCommand;
import io.intino.monet.box.util.FormHelper;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.FormDefinition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.LocalFormStore;

import java.io.File;
import java.io.IOException;
import java.time.Instant;

public class PutFinishOrderAction extends MonetAction {
	public MonetBox box;
	public String input;
	public String code;
	public String orderId;
	public String properties;

	public Boolean execute() throws Conflict, BadRequest {
		OrderApi orderApi = box.orderApi();
		io.intino.monet.engine.Order order = orderApi.order(orderId);
		if (order == null) throw new Conflict("Order not found");

		order.input(input);
		order.properties(properties);

		ResolveOrderCommand command = new ResolveOrderCommand(box);
		command.author = "api";
		command.ts = Instant.now();
		command.order = order;
		command.testEnvironment = false;
		command.language = "en";
		command.form = form(order);
		command.execute();

		return true;
	}

	private Form form(io.intino.monet.engine.Order order) {
		return new Form(formDefinition(order), store(order));
	}

	private FormDefinition formDefinition(io.intino.monet.engine.Order order) {
		return FormHelper.formDefinition(box, order);
	}

	private FormStore store(io.intino.monet.engine.Order order) {
		File directory = box.archetype().repository().workorders().getStoreDirectory(order.store());
		LocalFormStore result = new LocalFormStore(directory);
		try {
			result.load();
		} catch (IOException ignored) {
		}
		fillInputs(result, order);
		return result;
	}

	private void fillInputs(LocalFormStore result, io.intino.monet.engine.Order order) {
		order.inputMap().forEach(result::put);
	}

}