package io.intino.monet.box;

import io.intino.monet.engine.WorkReport;
import io.intino.monet.engine.edition.Form;

import java.io.File;

public interface WorkReportGenerator {

	boolean canGenerate(WorkReport workReport, Form form);

	File generate(WorkReport workReport, Form form, boolean preview);

	interface Archetype {

		File tmp();
		OrderTypes orderTypes();

		static Archetype wrap(io.intino.monet.archetype.Archetype archetype) {
			return new Archetype() {
				@Override
				public File tmp() {
					return archetype.tmp().root();
				}

				@Override
				public OrderTypes orderTypes() {
					return OrderTypes.wrap(archetype.definitions().orderTypes());
				}
			};
		}

		interface OrderTypes {

			File defaultWorkReport(String code);
			File areaWorkReport(String order, String area);
			File languageWorkReport(String order, String language);
			File workReportCalculation(String order);

			static OrderTypes wrap(io.intino.monet.archetype.Archetype.Definitions.OrderTypes orderTypes) {
				return new OrderTypes() {
					@Override
					public File defaultWorkReport(String code) {
						return orderTypes.defaultWorkReport(code);
					}

					@Override
					public File areaWorkReport(String order, String area) {
						return orderTypes.areaWorkReport(order, area);
					}

					@Override
					public File languageWorkReport(String order, String language) {
						return orderTypes.languageWorkReport(order, language);
					}

					@Override
					public File workReportCalculation(String order) {
						return orderTypes.workReportCalculation(order);
					}
				};
			}

		}
	}
}
