import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiDisplayStamp from "alexandria-ui-elements/src/displays/components/DisplayStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiImageEditable from "alexandria-ui-elements/src/displays/components/ImageEditable";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiSelectorCheckBox from "alexandria-ui-elements/src/displays/components/SelectorCheckBox";
import UiNumberEditable from "alexandria-ui-elements/src/displays/components/NumberEditable";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysAttachmentRenderer from "monet-elements/src/displays/AttachmentRenderer";
import DisplaysCheckListWizardStepPackageFile from "monet-elements/gen/displays/templates/CheckListWizardStepPackageFile";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CheckListWizardStepNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CheckListWizardStepRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CheckListWizardStep extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CheckListWizardStepNotifier(this);
		this.requester = new CheckListWizardStepRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473" visible={false} layout="vertical flexible centercenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a465278217" format="h6 bold" mode="normal">
					</UiText>
					<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a568874973" format="cleanHtmlStyle htmlSize" visible={false} mode="normal" language="Html" value="">
					</UiTextCode>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a_553791298" visible={false} layout="vertical">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a_553791298.a18825670" layout="horizontal centerjustified">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a_553791298.a18825670.a_1943047394" title="Continue" target="self" mode="Link" size="Medium">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a_553791298.a_4078173" format="doubleAirTop" layout="horizontal centerjustified">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a_553791298.a_4078173.a476133832" title="Skip step" target="self" mode="Link" size="Medium" format="secondaryColor">
							</UiAction>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a_1380032973" visible={false} layout="vertical">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1748906473.a_1380032973.a_517169614" title="Continue" target="self" mode="Link" size="Medium">
						</UiAction>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220" visible={false} layout="vertical">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a695283512" format="airBottom" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a695283512.a1567478932" format="h6 bold" mode="normal">
						</UiText>
						<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a695283512.a_226854158" format="cleanHtmlStyle htmlSize" visible={false} mode="normal" language="Html" value="">
						</UiTextCode>
						<UiDisplayStamp context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a695283512.a481742748" visible={false}>
						</UiDisplayStamp>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265" layout="vertical flexible">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753" layout="vertical">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_2008186040" format="orderEditorWithPhoto" visible={false} layout="vertical">
								<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_2008186040.a1751185215" format="airBottom minImageHeight" width="100.0%" height="80.0%">
								</UiImageEditable>
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_2008186040.a997930817" mode="normal" placeholder="Photo description (optional)">
								</UiTextEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a1720697122" format="orderEditorWithPhoto" visible={false} layout="vertical">
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a1720697122.a16081227" format="doubleAirBottom" mode="normal" editionMode="Raw" rows={5} placeholder="">
								</UiTextEditable>
								<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a1720697122.a430132279" label="Photo (optional)" format="minImageHeight" width="100.0%" height="65.0%">
								</UiImageEditable>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_570338098" format="orderEditorWithPhoto" visible={false} layout="vertical">
								<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_570338098.a_851317069" format="airBottom" width="100.0%" height="100.0%">
								</UiImageEditable>
							</UiBlock>
							<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a767192047" visible={false} pattern="DD/MM/YYYY" embedded={true}>
							</UiDateEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_824144219" visible={false} layout="vertical">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_824144219.a35067728" label="Selected option" mode="normal">
								</UiText>
								<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_824144219.a268663923" visible={false} mode="normal" placeholder="Filter options...">
								</UiTextEditable>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_824144219.a_1424472341" multipleSelection={false}>
								</UiSelectorListBox>
							</UiBlock>
							<UiSelectorCheckBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1973852375" visible={false} multipleSelection={true} layout="Vertical">
							</UiSelectorCheckBox>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1482128599" format="doubleAirTop" visible={false} layout="vertical start">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1482128599.a_1686170480" format="h5 bold" mode="normal" translate={true} value="Indicate your response">
								</UiText>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1482128599.a1338405704" format="middleAirTop" layout="horizontal startjustified">
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1482128599.a1338405704.a632549679" format="airRight" layout="vertical" width="100px" height="-1px">
										<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1482128599.a1338405704.a632549679.a1871767577" title="" target="self" mode="Button" size="Small" highlighted="Outline">
										</UiAction>
									</UiBlock>
									<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1482128599.a1338405704.a_148125655" layout="vertical" width="100px" height="-1px">
										<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1482128599.a1338405704.a_148125655.a_540995423" title="" target="self" mode="Button" size="Small" highlighted="Fill">
										</UiAction>
									</UiBlock>
								</UiBlock>
							</UiBlock>
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_21516848" visible={false} mode="normal" placeholder="">
							</UiTextEditable>
							<UiNumberEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1082190732" visible={false} style="Number" value={0.0} min={-1.0} max={-1.0} step={-1.0} decimals={0} expanded={true}>
							</UiNumberEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1410790500" visible={false} layout="vertical">
								<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1410790500.a_220113897" format="airBottom" multiple={{instances:"packageField",arrangement:"Vertical",noItemsMessage:"No files added",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
								</UiMultiple>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1410790500.a1294995987" layout="horizontal startjustified">
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a_1207462753.a_1410790500.a1294995987.a1138870728" title="Add" target="self" mode="Button" size="Small" highlighted="Outline">
									</UiAction>
								</UiBlock>
							</UiBlock>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a1776572012" format="airTop" layout="horizontal">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1555123220.a_619109265.a1776572012.a1759475632" title="Skip step" target="self" mode="Link" size="Medium" format="secondaryColor" visible={false}>
							</UiAction>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CheckListWizardStep));
DisplayFactory.register("CheckListWizardStep", withStyles(styles, { withTheme: true })(withSnackbar(CheckListWizardStep)));