/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui.displays;

import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractRouteDispatcher
implements DisplayRouteDispatcher {
    private static Map<String, String> patterns = new HashMap<String, String>();

    public AbstractRouteDispatcher() {
        this.registerPatterns();
    }

    public void dispatch(Soul soul, String address) {
        address = address.replaceFirst(soul.session().browser().basePath(), "");
        List<String> params = this.paramsOf(address);
        if (address.length() <= 1) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("home"))) {
            this.dispatchHome(soul);
            return;
        }
        if (address.matches(patterns.get("orderPage"))) {
            this.dispatchOrderPage(soul, params.get(0));
            return;
        }
    }

    public abstract void dispatchHome(Soul var1);

    public abstract void dispatchOrderPage(Soul var1, String var2);

    private void registerPatterns() {
        if (patterns.size() > 0) {
            return;
        }
        patterns.put("home", "");
        patterns.put("orderPage", "\\/order\\/([^\\/]*)");
    }

    private String patternOf(String address) {
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("home"))) {
            return patterns.get("home");
        }
        if (address.matches(patterns.get("orderPage"))) {
            return patterns.get("orderPage");
        }
        return null;
    }

    private List<String> paramsOf(String address) {
        return this.paramsOf(address, this.patternOf(address));
    }

    private List<String> paramsOf(String address, String pattern) {
        if (pattern == null) {
            return Collections.emptyList();
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(address);
        if (!m.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i <= m.groupCount(); ++i) {
            result.add(m.group(i).split("\\?")[0]);
        }
        return this.addQueryStringParams(address, result);
    }

    private List<String> addQueryStringParams(String address, List<String> result) {
        if (address.indexOf("?") == -1) {
            return result;
        }
        String[] parameters = address.split("\\?")[1].split("&");
        for (int i = 0; i < parameters.length; ++i) {
            result.add(parameters[i].split("=")[1]);
        }
        return result;
    }
}

