/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box;

import io.intino.monet.archetype.Archetype;
import io.intino.monet.engine.WorkReport;
import io.intino.monet.engine.edition.Form;
import java.io.File;

public interface WorkReportGenerator {
    public boolean canGenerate(WorkReport var1, Form var2);

    public File generate(WorkReport var1, Form var2, boolean var3);

    public static interface Archetype {
        public File tmp();

        public OrderTypes orderTypes();

        public static Archetype wrap(final io.intino.monet.archetype.Archetype archetype) {
            return new Archetype(){

                @Override
                public File tmp() {
                    return archetype.tmp().root();
                }

                @Override
                public OrderTypes orderTypes() {
                    return OrderTypes.wrap(archetype.definitions().orderTypes());
                }
            };
        }

        public static interface OrderTypes {
            public File defaultWorkReport(String var1);

            public File areaWorkReport(String var1, String var2);

            public File languageWorkReport(String var1, String var2);

            public File workReportCalculation(String var1);

            public static OrderTypes wrap(final Archetype.Definitions.OrderTypes orderTypes) {
                return new OrderTypes(){

                    @Override
                    public File defaultWorkReport(String code) {
                        return orderTypes.defaultWorkReport(code);
                    }

                    @Override
                    public File areaWorkReport(String order, String area) {
                        return orderTypes.areaWorkReport(order, area);
                    }

                    @Override
                    public File languageWorkReport(String order, String language) {
                        return orderTypes.languageWorkReport(order, language);
                    }

                    @Override
                    public File workReportCalculation(String order) {
                        return orderTypes.workReportCalculation(order);
                    }
                };
            }
        }
    }
}

