/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box;

import io.intino.alexandria.office.components.Image;
import io.intino.alexandria.office.components.ImageView;

public interface ImageViewFactory {
    public ImageView create(Image var1);

    public static class Default
    implements ImageViewFactory {
        @Override
        public ImageView create(Image image) {
            ImageView imageView = new ImageView(image);
            imageView.keepAspectRatio(true);
            if (image.getWidth() >= image.getHeight()) {
                Default.fixWidthThenAdjustHeight(imageView);
            } else {
                Default.fixHeightThenAdjustWidth(imageView);
            }
            return imageView;
        }

        private static void fixHeightThenAdjustWidth(ImageView imageView) {
            imageView.widthWrapping(ImageView.WrapOption.ClampToPage);
            imageView.heightWrapping(ImageView.WrapOption.ClampToTemplate);
        }

        private static void fixWidthThenAdjustHeight(ImageView imageView) {
            imageView.widthWrapping(ImageView.WrapOption.ClampToTemplate);
            imageView.heightWrapping(ImageView.WrapOption.ClampToPage);
        }
    }
}

