package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.exceptions.*;
import io.intino.monet.box.*;

import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.displays.templates.AbstractHeader;

import java.net.URL;

public class Header extends AbstractHeader<MonetBox> {

    public Header(MonetBox box) {
        super(box);
    }

    public void embedded(boolean embedded) {
        if (!embedded) return;
        content.hide();
    }

    @Override
    public void init() {
        super.init();
        initLogo();
        initTitle();
    }

    private void initLogo() {
        URL logo = box().logoUrl();
        if (logo != null) this.logo.value(logo, "image/png", "logo.png");
    }

    private void initTitle() {
        MonetConfiguration configuration = box().configuration();
        String title = configuration.title();
        appTitle.visible(title != null && !title.isEmpty());
        if (appTitle.isVisible()) appTitle.value(title);
        String description = configuration.description();
        appDescription.visible(description != null && !description.isEmpty());
        if (appDescription.isVisible()) appDescription.value(description);
    }
}