package io.intino.monet.box.actions;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.monet.box.schemas.Order;
import io.intino.monet.box.util.SchemaHelper;

public class GetOrderAction extends MonetAction {
	public String orderId;

	public io.intino.monet.box.schemas.Order execute() throws Conflict, BadRequest {
		io.intino.monet.engine.Order order = box.orderApi().order(orderId);
		if (order == null) throw new Conflict("Order not found");
		return SchemaHelper.schemaOf(order);
	}

}