package io.intino.monet.box;

import io.intino.alexandria.ui.services.translator.Dictionary;

import java.util.HashMap;
import java.util.Map;
import java.util.ArrayList;
import java.util.List;

public class I18n {
	private static Map<String, Dictionary> dictionaries = new HashMap<>();

	public static String translate(String word, String language) {
		language = dictionaries.containsKey(language) ? language : "en";
		Dictionary dictionary = dictionaries.get(language);
		return dictionary != null && dictionary.containsKey(word) ? dictionary.get(word) : word;
	}

    public static List<Dictionary> dictionaries() {
        return new ArrayList<>(dictionaries.values());
    }

	static {
		dictionaries.put("pt", new Dictionary() {{
			put("No elements", "Sem elementos");
			put("Could not resolve order", "Não foi possível resolver o pedido");
			put("Could not resolve order. Check parameters.", "Não foi possível resolver o pedido. Verifique os parâmetros.");
			put("Could not preview order", "Não foi possível visualizar o pedido");
			put("Could not preview order. Check parameters.", "Não foi possível visualizar o pedido. Verifique os parâmetros.");
			put("Refresh", "Atualizar");
			put("Preview", "Vista prévia");
			put("Cancel", "Cancelar");
			put("Accept", "Aceitar");
			put("Previous", "Anterior");
			put("Next", "Próximo");
			put("Finish", "Finalizar");
			put("Continue", "Continuar");
			put("Add", "Adicionar");
			put("Download", "Download");
			put("Remove", "Retirar");
			put("Affirm", "Confirme");
			put("Photo description (optional)", "Descrição da foto (opcional)");
			put("Photo (optional)", "Foto (opcional)");
			put("Do you want to complete this section?", "Deseja completar esta seção?");
			put("No files added", "Nenhum arquivo adicionado");
			put("Value out of range: %.1f-%.1f", "Valor fora do intervalo: %.1f-%.1f");
			put("Restart", "Reiniciar");
			put("Are you sure to restart fields?", "Tem certeza de reiniciar os campos?");
			put("Are you sure to terminate order?", "Tem certeza de encerrar o pedido?");
			put("%d steps", "%d passos");
			put("Fill inputs", "Encher inputs");
			put("Edition", "Edição");
			put("Index", "Índice");
			put("No steps completed", "Nenhuma etapa concluída");
			put("Not filled", "Não preenchido");
			put("Filled", "Preenchido");
			put("file", "arquivo");
			put("files", "arquivos");
			put("Congratulations! you have finished order", "Parabéns! você terminou o pedido");
			put("View work report", "Ver relatório de trabalho");
			put("View index", "Ver índice");
			put("No files", "Sem arquivos");
			put("Image defined", "Imagem definida");
			put("Signature defined", "Assinatura definida");
			put("Image not defined", "Imagem não definida");
			put("Signature not defined", "Assinatura não definida");
			put("Work report not found", "Relatório de trabalho não encontrado");
			put("Order saved", "Pedido salvo");
			put("Skip step", "Pular etapa");
			put("Order not found", "Pedido não encontrado");
			put("Order finished. Congratulations!", "Encomenda finalizada. Parabéns!");
			put("View details", "Ver detalhes");
			put("Indicate your response", "Indique sua resposta");
		}}.language("pt"));
		dictionaries.put("es", new Dictionary() {{
			put("No elements", "Sin elementos");
			put("Could not resolve order", "No se pudo resolver la orden");
			put("Could not resolve order. Check parameters.", "No se pudo resolver la orden. Compruebe los parámetros.");
			put("Could not preview order", "No se pudo generar la vista previa");
			put("Could not preview order. Check parameters.", "No se pudo generar la vista previa. Compruebe los parámetros.");
			put("Refresh", "Refrescar");
			put("Preview", "Vista previa");
			put("Cancel", "Cancelar");
			put("Accept", "Aceptar");
			put("Previous", "Anterior");
			put("Next", "Siguiente");
			put("Finish", "Finalizar");
			put("Continue", "Continuar");
			put("Add", "Añadir");
			put("Download", "Descargar");
			put("Remove", "Quitar");
			put("Affirm", "Confirmar");
			put("Photo description (optional)", "Descripción de la foto (opcional)");
			put("Photo (optional)", "Foto (opcional)");
			put("Do you want to complete this section?", "¿Desea cumplimentar esta sección?");
			put("No files added", "No se han añadido archivos");
			put("Value out of range: %.1f-%.1f", "Valor fuera de rango: %.1f-%.1f");
			put("Restart", "Reiniciar");
			put("Are you sure to restart fields?", "¿Está seguro/a que desea reiniciar los campos?");
			put("Are you sure to terminate order?", "¿Está seguro que desea terminar la orden de trabajo?");
			put("%d steps", "%d pasos");
			put("Fill inputs", "Rellenar inputs");
			put("Edition", "Edición");
			put("Index", "Índice");
			put("No steps completed", "Sin pasos completados");
			put("Not filled", "Sin cumplimentar");
			put("Filled", "Cumplimentado");
			put("file", "archivo");
			put("files", "archivos");
			put("Congratulations! you have finished order", "¡Felicidades! Ha finalizado la orden");
			put("View work report", "Ver el parte de trabajo");
			put("View index", "Ver índice");
			put("No files", "Sin archivos");
			put("Image defined", "Imagen definida");
			put("Signature defined", "Firma definida");
			put("Image not defined", "Imagen no definida");
			put("Signature not defined", "Firma no definida");
			put("Work report not found", "Parte de trabajo no encontrado");
			put("Order saved", "Orden guardada");
			put("Skip step", "Saltar paso");
			put("Order not found", "Orden no encontrada");
			put("Order finished. Congratulations!", "Orden finalizada. ¡Felicidades!");
			put("View details", "Ver detalles");
			put("Indicate your response", "Indique su respuesta");
		}}.language("es"));
	}
}