package io.intino.monet.box.workreports;

import io.intino.alexandria.office.DocxBuilder;
import io.intino.alexandria.office.ImageView;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class WorkReportTemplate {

    private final File file;
    private final DocxBuilder docxBuilder;
    private boolean empty = true;
    private final Set<String> setters = new HashSet<>();

    public WorkReportTemplate(File templateFile) {
        if(!templateFile.exists()) throw new IllegalArgumentException("Template file " + templateFile + " does not exist");
        this.file = templateFile;
        this.docxBuilder = DocxBuilder.create(templateFile);
    }

    public File file() {
        return file;
    }

    public boolean contains(String field) {
        return setters.contains(field);
    }

    public WorkReportTemplate set(String field, String value) {
        setters.add(field);
        docxBuilder.replace(field, value);
        empty = false;
        return this;
    }

    public WorkReportTemplate set(String field, ImageView value) {
        setters.add(field);
        docxBuilder.replace(field, value);
        empty = false;
        return this;
    }

    public void save(File file) throws IOException {
        docxBuilder.save(file);
    }

    public boolean empty() {
        return empty;
    }

    @Override
    public String toString() {
        return "WorkReportTemplate:" + file.toString();
    }
}
